<?php


namespace App\Services;


use App\Repositories\CustomerRepository;
use App\Repositories\PhoneRepository;
use App\Validators\PhoneValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class PhoneService extends Service
{
    private $repository;
    private $validator;

    public function __construct(PhoneRepository $repository, PhoneValidator $validator, CustomerRepository $clientRepo)
    {
        $this->repository = $repository;
        $this->validator = $validator;
        $this->clientRepo = $clientRepo;
    }

    public function insert($request)
    {
        foreach ($request as $items) {
            $contact = $items;
            $contact['nrTelefone'] = preg_replace('/\D/', '', $items['nrTelefone']);
            $contact['dtAlteracao'] = Carbon::now();
            $contact['flAtivo'] = 1;

            $this->validator->with($contact)->passesOrFail(ValidatorInterface::RULE_CREATE);

            try {
                $response = $this->repository->create($contact);
            } catch (\Exception $e) {
                return $e;
            }
        }

        return $response;
    }
    public function update($request, $id)
    {
        $this->delete($id);

        return $this->insert($request);
    }

    public function delete($id)
    {
       return $this->repository->deleteWhere(['idCliente' => $id]);
    }

}
