<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtItensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Itens')) {

            Schema::create('mt_Itens', function (Blueprint $table) {
                $table->smallInteger('idComanda', false, true);
                $table->smallInteger('nrItem', false, true);
                $table->smallInteger('idPessoa', false, true)->default(1);
                $table->integer('idProduto', false, false);
                $table->string('stOperador', 20);
                $table->decimal('nrQuantidade', 9, 3);
                $table->dateTime('dtData');
                $table->string('idMicroterminal', 15);
                $table->decimal('vrUnitario', 7, 2);
                $table->decimal('vrTotal', 7, 2);
                $table->float('flNovo')->default(1);
                $table->string('stIncremento', 255);
                $table->string('stValores', 50);
                $table->string('stCodigos', 50);
                $table->string('stQuantidades', 50);
                $table->string('stItensAdicionais', 255);
                $table->float('flItemAdicional')->default(0);
                $table->float('flAgregaValor')->default(0);
                $table->float('flViagem')->default(0);
                $table->integer('nrItemVinculado', false, false)->default(0);
                $table->float('flSem')->default(0);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Itens');

    }
}
