<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVwSalesItemsReport extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement($this->dropView());

        DB::statement("
        create view vw_sales_items_report as
        select
        p.idproduto as 'idProduto',
        i.idcodproduto as 'idCodProduto',
        p.stproduto as 'stProduto',
        p.idaliquota as 'idAliquota',
        a.staliquota as 'stAliquota',
        p.idcategoria as 'idCategoria',
        c.stcategoria as 'stCategoria',
        p.idsetor as 'idSetor',
        s.stsetor as 'stSetor',
        p.idmedida as 'idMedida',
        m.stmedida as 'stMedida',
        p.nrNCM as 'nrNCM',
        i.flativo as 'flAtivo',
        i.nrquantidade as 'nrQuantidade',
        i.vrunitario as 'vrUnitario',
        i.vrdesconto as 'vrDesconto',
        i.vrtotal as 'vrTotal',
        i.vrTotal - i.vrDesconto as 'total',
        i.dtdata as 'dtData',
        i.idItem as 'idItem',
        i.idVenda as 'idVenda',
        i.idAbertura as 'idAbertura'
        from (select * from cx_itens union select * from cx_itens_temp) I
        join prd_produtos p on p.idproduto = i.idproduto
        join prd_Aliquotas a on p.idAliquota = a.idAliquota
        join prd_Categorias c on p.idCategoria = c.idCategoria
        join prd_Setores s on p.idSetor = s.idSetor
        join prd_Medidas m on p.idMedida = m.idMedida
        ");


    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement($this->dropView());
    }

    private function dropView()
    {
        return "if exists(select 1 from sys.views where name= 'vw_sales_items_report' and type='v')
                drop view vw_sales_items_report;";
    }

}
