<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstLotesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Lotes')) {

            DB::statement('CREATE TABLE [dbo].[est_Lotes](
                  [dtAlteracao] [datetime] NOT NULL,
                  [idLote] [int] NOT NULL,
                  [idMovimentacao] [int] NOT NULL,
                  [idAbertura] [int] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [stLote] [nvarchar](20) NOT NULL,
                  CONSTRAINT [PK_est_Lotes] PRIMARY KEY CLUSTERED
                    (
                      [idLote] ASC,
                      [idMovimentacao] ASC,
                      [idAbertura] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Lotes');

    }
}
