<div class="col-md-12" id="app">
    <div class="panel">
        <div class="panel-heading clearfix">
            <h3 class="panel-title" style="display: inline-block; line-height: 2em">
                Monitor de Preparo
            </h3>
            <div class="btn-group pull-right">
                <select class="form-control" v-model="selected" @change="changeFilter($event)">
                    <option v-for="i in printers" v-bind:value="i.idPrint">{{i.idPrint}} - {{i.stPrint}}</option>
                    <option value="all">Todas</option>
                </select>
            </div>
            <hr/>
        </div>



        <div class="row">
            <div class="card" v-if="selected !== 'all'">
                <div class="col-md-4" v-for="order in orders">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <h4 class="panel-title">Pedido #{{order.payload.idAtendimento}}</h4>
                        </div>
                        <div class="panel-body">
                            <!-- Table -->
                            <table class="table">
                                <thead>
                                <tr>
                                    <td>Qtd</td>
                                    <td>Descrição</td>
                                </tr>
                                </thead>
                                <tr v-for="item in order.payload.items">
                                    <td>{{item.quantidade}}</td>
                                    <td>
                                        <div class="row">
                                            {{item.codigo}} - {{item.descricao}}
                                        </div>
                                        <div v-if="item.subItens.length > 0">
                                            <div class="row" v-for="it in item.subItens">
                                                {{it.quantidade}} - {{it.descricao}}
                                            </div>
                                        </div>

                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="panel-footer text-center">
                            <button class="btn btn-sm btn-primary">OK</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row" v-if="selected == 'all'">
            <div class="panel panel-default"  v-for="printer in printers">
                <div class="panel-heading">
                    <h3 class="panel-title">{{printer.stPrint}} - {{printer.idPrint}}</h3>
                </div>
                <div class="panel-body">
                    <div class="col-md-4" v-for="order in ordersFiltered(printer.idPrint)">
                        <div class="panel panel-default">
                            <div class="panel-heading">
                                <h4 class="panel-title">Pedido #{{order.payload.idAtendimento}}</h4>
                            </div>
                            <div class="panel-body">
                                <!-- Table -->
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <td>Qtd</td>
                                            <td>Descrição</td>
                                        </tr>
                                    </thead>
                                    <tr v-for="item in order.payload.items">
                                        <td>{{item.quantidade}}</td>
                                        <td>
                                            <div class="row">
                                                {{item.codigo}} - {{item.descricao}}
                                            </div>
                                            <div v-if="item.subItens.length > 0">
                                                <div class="row" v-for="it in item.subItens">
                                                    {{it.quantidade}} - {{it.descricao}}
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="panel-footer text-center">
                                <button class="btn btn-sm btn-primary" @click="concluded(order.id)">OK</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <pre>
{{orders}}
</pre>
    </div>

    <script>

        new Vue({
            el: '#app',
            data: {
                orders: [],
                selected: 'all',
                printers: []
            },
            methods: {
                getItens: function () {
                    axios.get(`/api/v1/monitor-preparo/${this.selected}`)
                        .then(res => {
                            if (res.data.length > 0) {
                                this.orders = res.data.map(it => {
                                    return {
                                        'id': it.id,
                                        'payload' : JSON.parse(it.payload)
                                    };
                                });
                            } else {
                                this.orders = []
                            }
                        })
                },
                getPrinters: function () {
                    axios.get('/api/v1/impressoras')
                        .then(res => {
                            this.printers = res.data;
                        })
                },

                changeFilter(event) {
                    localStorage.setItem('filter', this.selected);
                    this.getItens();
                },
                ordersFiltered(idPrint){
                    return this.orders.filter(it => {
                        return it.payload.idPrint === idPrint;
                    })
                },
                concluded(id){
                    console.log(id)
                }
            },
            created() {
                var sel = localStorage.getItem('filter');
                this.selected = sel !== null ? sel : 'all';

                this.getPrinters();
                this.getItens();
            },
            computed: {

            }
        })

    </script>
