<?php
/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */
class FinCategoriaContas extends Conexao {
    private $_name = "fin_CategoriaContas";
    
    public function getContaReceberGruposEntrada(){
        $sql = "SELECT distinct c.* 
                FROM ".$this->_name." c
                JOIN fin_TipoContas t
                ON c.idCategoriaConta = t.idCategoriaConta
                WHERE t.flEntrada = 1;";
        return parent::executar($sql);
    }
    
    public function getContaReceberGruposSaida(){
        $sql = "SELECT distinct c.* 
                FROM ".$this->_name." c
                JOIN fin_TipoContas t
                ON c.idCategoriaConta = t.idCategoriaConta
                WHERE t.flEntrada = 0;";
        return parent::executar($sql);
    }
    
    public function getAll(){
        $sql = "SELECT * FROM ".$this->_name." ORDER BY stCategoriaConta ASC;";
        return parent::executar($sql);
    }
    
    public function getAllComTipoConta(){
        $sql = "SELECT * FROM fin_CategoriaContas c WHERE (SELECT COUNT(t.idTipoConta) FROM fin_TipoContas t WHERE t.idCategoriaConta = c.idCategoriaConta) > 0 ORDER BY c.stCategoriaConta ASC";
        return parent::executar($sql);
    }
}