<?php
/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */
class Master extends Conexao {
    private $_name = "master";
    private $_min_ranger = 0;
    private $_max_ranger = 0;
    private $_qnt_letra_comanda = 0;
    private $_qnt_digito_comanda = 0;
    private $_qnt_verificador_comanda = 0;
    private $_letra_comanda = "W";//letra que representa as letras
    private $_digito_comanda = "D";//letra que representa os digitos
    private $_verificador_comanda = "V";//letra que representa o digito verificador
    
    public function getRanger(){
        $sql = "SELECT TOP(1) stMesas FROM ".$this->_name.";";
        $objSource = parent::executar($sql);
        $objRst = mssql_fetch_object($objSource);
        $RANGER = explode("@", $objRst->stMesas);
        $this->_min_ranger = $RANGER[0];
        $this->_max_ranger = $RANGER[1];
        return $this;
    }
    
    public function getRangerMin(){
        return $this->_min_ranger;//voce precisa acionar o metodo getranger antes de acionar este
    }
    
    public function getRangerMax(){
        return $this->_max_ranger;//voce precisa acionar o metodo getranger antes de acionar este
    }
    
    public function getTipoComanda(){
        $sql = "SELECT TOP(1) stTipoComanda FROM ".$this->_name.";";
        $objSource = parent::executar($sql);
        $objRst = mssql_fetch_object($objSource);
        $this->_qnt_letra_comanda = (int) substr_count($objRst->stTipoComanda, $this->_letra_comanda);
        $this->_qnt_digito_comanda = (int) substr_count($objRst->stTipoComanda, $this->_digito_comanda);
        $this->_qnt_verificador_comanda = (int) substr_count($objRst->stTipoComanda, $this->_verificador_comanda);
        
        return $this;
    }
    
    public function getQntLetraTipoComanda(){
        return $this->_qnt_letra_comanda;//voc precisa acionar o metodo gettipocomanda antes de acionar este
    }
    
    public function getQntDigitoComanda(){
        return $this->_qnt_digito_comanda;//voc precisa acionar o metodo gettipocomanda antes de acionar este
    }
    
    public function getQntVerificadorComanda(){
        return $this->_qnt_verificador_comanda;//voc precisa acionar o metodo gettipocomanda antes de acionar este
    }
    
    public function getLetraComanda(){
        $sql = "SELECT TOP(1) stLetraComanda FROM ".$this->_name.";";
        $objSource = parent::executar($sql);
        $objRst = mssql_fetch_object($objSource);
        return $objRst->stLetraComanda;
    }
    
    public function getRepresentanteLetra(){
        return $this->_letra_comanda;
    }
    
    public function getRepresentanteDigito(){
        return $this->_digito_comanda;
    }
    
    public function getRepresentanteVerificador(){
        return $this->_verificador_comanda;
    }
    
    public function validaComanda($idcomanda){
        $this->getTipoComanda();
        
        if(strlen($idcomanda) != ($this->_qnt_digito_comanda + $this->_qnt_letra_comanda + $this->_qnt_verificador_comanda))
            return false;
        
        $letra = substr($idcomanda, 0, stripos($idcomanda, $this->_letra_comanda) + 1);
        if(is_numeric($letra) || strlen($letra) != $this->_qnt_letra_comanda)
            return false;
        
        $digito = substr($idcomanda, stripos($idcomanda, $this->_letra_comanda) + 1, $this->_qnt_digito_comanda);
        if(!is_numeric($digito) || strlen($digito) != $this->_qnt_digito_comanda)
            return false;
        
        if($this->_qnt_verificador_comanda != 0) :
            $verificador = (int) substr($idcomanda, -$this->_qnt_verificador_comanda);
            if((!empty($verificador) || !is_null($verificador)) && (!is_int($verificador) || strlen($verificador) != $this->_qnt_verificador_comanda))
                return false;
        endif;
        
    return true;
    }
    
}