document.addEventListener("DOMContentLoaded", function() {
	$(function () {
		$('[data-toggle="tooltip"]').tooltip()
	});
	$.post('modulos/resources/functions.php', {action: 'getConfig'}, function (response) {
		if (response.status) {
			$('#strModulos').val(response.msg);
		}else{
			$('#strModulos').val('1;1;1;0;0;0;0;0;0;0');
		}
		var values = $('#strModulos').val().split(';');
		for (var i = 0; i < values.length; i++) {
			if (values[i] == 1) {
				$('#status'+i).addClass('btn-success');
				$('#status'+i).removeClass('btn-default');
				$('#cog'+i).removeClass('disabled');
				$('#status'+i).html('Instalado');
			}else{
				$('#status'+i).removeClass('btn-success');
				$('#status'+i).addClass('btn-default');
				$('#cog'+i).addClass('disabled');
				$('#status'+i).html('Instalar');
			}
			$('#status'+i).val(values[i]);
		}
		if (values[4] == 0) {
			$('#estoque').attr('disabled', true);
			$('#estoque').prop('checked', false);
		}else{
			$('#estoque').attr('disabled', false);
		}
	});

	$('#modalModulo').on('hidden.bs.modal', function () {
		for (var i = 0; i < 10; i++) {
			$('#modal-body-'+i).addClass('hidden');
		}
	});
});

function changeValue(pos) {
	toastr.options = {"positionClass": "toast-bottom-right"};
	var newString = '';
	var string = $('#strModulos').val().split(';');
	var value = $('#status'+pos).val();
	if (value == 0) {
		value = 1;
	}else{
		value = 0;
	}
	string[pos] = value;
	for (var i = 0; i < string.length; i++) {
		if (i != 0) {newString += ';'}
		newString += string[i];
	}
	$.post('modulos/resources/functions.php', {action: 'saveConfig', string: newString}, function (response) {
		if (response.status) {
			if (value == 1) {
				$('#status'+pos).addClass('btn-success');
				$('#status'+pos).removeClass('btn-default');
				$('#cog'+pos).removeClass('disabled');
				$('#status'+pos).html('Instalado');
			}else{
				$('#status'+pos).removeClass('btn-success');
				$('#status'+pos).addClass('btn-default');
				$('#cog'+pos).addClass('disabled');
				$('#status'+pos).html('Instalar');
			}

			$('#strModulos').val(newString);
			$('#status'+pos).val(value);

			toastr.success(response.msg);
			setTimeout(function(){location.reload();},1000);
		}else{
			toastr.error(response.msg);
		}
	});
}

function checkButton(pos) {
	if ($('#status'+pos).html() == 'Instalar') {
		changeValue(pos);
	}
}

function openModal(pos){
	switch(pos){
		case 0:
		$('#modal-title').html('Configuração de Usuários');
		break;
		case 1:
		$('#modal-title').html('Configuração de Produtos');
		break;
		case 2:
		$('#modal-title').html('Configuração de Clientes');
		break;
		case 3:
		$('#modal-title').html('Configuração de Fornecedores');
		break;
		case 4:
		$('#modal-title').html('Configuração de Estoques');
		break;
		case 5:
		$('#modal-title').html('Configuração de Tesouraria');
		break;
		case 6:
		$('#modal-title').html('Configuração de Microterminal');
		break;
		case 7:
		$('#modal-title').html('Configuração de Delivery');
		break;
		case 8:
		$('#modal-title').html('Configuração de Relatórios');
		break;
		case 9:
		$('#modal-title').html('Configuração do Financeiro');
		break;
	}
	var data = {action: 'getSubConfig', pos:pos};
	$.post('modulos/resources/functions.php', data, function (response) {
		var values = response.split(';');
		var positions = [];
		$("#modal-body-"+pos+" :input").each(function() {
			positions.push($(this)[0].id);
		});
		for (var i = 0; i < positions.length; i++) {
			if (values[i] == 'true') {
				$('#'+positions[i]).attr('checked', true);
			}else{
				$('#'+positions[i]).attr('checked', false);
			}
		}
		checkCategory();
		$('#pos').val(pos);
		$('#modal-body-'+pos).removeClass('hidden');
		$('#modalModulo').modal('show');
	});
}

function checkCategory() {
	if ($('#categoria').is(':checked')) {
		$('#subcategoria').removeAttr('disabled');
	}else{
		$('#subcategoria').attr('disabled', 'disabled');
		$('#subcategoria').removeAttr('checked');
	}
}

function saveConfigModal() {
	toastr.options = {"positionClass": "toast-bottom-right"};
	var pos = $('#pos').val();
	var action = $('#action').val();
	var string = '';
	$("#modal-body-"+pos+" :input").each(function() {
		var value = '';
		if ($(this).is(':checkbox') || $(this).is(':radio') ) {
			value = $("#"+$(this)[0].id).is(':checked');
		}else{
			value = $("#"+$(this)[0].id).val();
		}
		string += ';'+value;
	});
	string = string.substr(1);
	var data = {action: 'saveSubConfig', pos:pos ,string: string};
	$.post('modulos/resources/functions.php', data, function (response) {
		if (response.status) {
			toastr.success(response.msg);
			setTimeout(function(){location.reload();},1000);
		}else{
			toastr.error(response.msg);
		}
	});
}

function teste() {
	$.post('modulos/resources/functions.php', {action:'run'}, function (response) {
		console.log(response);
	});
}