<?php
require_once "../functions.php";
require_once "resources/php/presidente_functions.php";

header('Content-type: application/json');

db_conn();
logincheck();

if (autorization(35) == false)
{
    die(retornaJson(false, "Desculpe, você não tem permissão para visualizar esta área.<br><br>"));
}

$trans = true;

beginTransaction();

$res = mssql_query("SELECT MAX(idDetalhe) FROM cx_GerenciadorDetalhes");
$row = mssql_fetch_row($res) or $trans=false;

$idDetalhe = $row[0] + 1; //Busco o maior idDetalhe em GerenciadorDetalhes e o incremento em $idDetalhe

$vrTrocoEncerramento = htmlspecialchars(strtoupper($_REQUEST['vrTrocoEncerramento']), ENT_QUOTES);
$idAbertura = htmlspecialchars(strtoupper($_REQUEST['idAbertura']), ENT_QUOTES);
$vrFechamento = htmlspecialchars(strtoupper(number_format($_REQUEST['vrFechamento'], 2, ',', '')), ENT_QUOTES);
$stOBS = htmlspecialchars(strtoupper($_REQUEST['stOBS']), ENT_QUOTES);
$chkAbrirRelatorio = $_REQUEST['chkAbrirRelatorio'];
$vrApurado = $_REQUEST['vrFechamento2'];
$vrDiferenca = $_REQUEST['vrDiferenca'];


$res = mssql_query("SELECT * FROM cx_Vendas_Temp WHERE idAbertura = '$idAbertura'") or $trans = false;

//Pego a quantidade de linhas na tabela de vendas desta abertura
if($trans){
    $cnt = mssql_num_rows($res);
}else{
    // header("LOCATION: ../?sec=erro&sub=42");
    die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
}

if ($cnt > 0){
    try{
        $QUERYS = array(
                        "INSERT INTO cx_Vendas SELECT * FROM cx_Vendas_Temp WHERE idAbertura = ".$idAbertura,// insere na tabela fixa de vendas as vendas temporarias
                        "INSERT INTO cx_Itens SELECT * FROM cx_Itens_Temp WHERE idAbertura = ".$idAbertura,//insere na tabela fixa de itens os itens temporarios
                        "INSERT INTO cx_FichaPagamentos SELECT * FROM cx_FichaRecebimentos_Temp WHERE idAbertura = ".$idAbertura,//insere na tabela fixa de valores formas de pagamento em  valores de forma de pagamento temporario
                        "DELETE FROM cx_Vendas_Temp WHERE idAbertura = ".$idAbertura,
                        "DELETE FROM cx_Itens_Temp WHERE idAbertura = ".$idAbertura,
                        "DELETE FROM cx_FichaRecebimentos_Temp WHERE idAbertura = ".$idAbertura,
                        "IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Vendas' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Vendas SET dtAlteracao = GETDATE() WHERE idAbertura = ".$idAbertura,
                        "IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Itens' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Itens SET dtAlteracao = GETDATE() WHERE idAbertura = ".$idAbertura,
                        "IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_FichaPagamentos' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_FichaPagamentos SET dtAlteracao = GETDATE() WHERE idAbertura = ".$idAbertura
                       );
        
        foreach($QUERYS as $sql){
            if(!empty($sql) || !is_null($sql))
                @mssql_query ($sql);
        }
    }catch(Exception $ex){
        $trans = false;
        // header("LOCATION: ../?sec=erro&sub=42");
        die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
    }
}

$sql = "SELECT stFormaPagamento, idFormaPagamento, SUM(vrPagamento) as vrPagamento, SUM(vrPagamento2) as vrPagamento2, SUM(vrPagamentoTotal) as vrPagamentoTotal ".
	   "FROM ".
	   "( ".
		   "SELECT SUM(Pagamento) as vrPagamento, stFormaPagamento, idFormaPagamento, NULL as vrPagamento2, NULL as vrPagamentoTotal ".
		   "FROM ".
		   "( ".
			   "SELECT SUM(p.vrFormaPagamento) as Pagamento, f.stFormaPagamento, f.idFormaPagamento ".
			   "FROM cx_FormasPagamento f ".
			   "LEFT JOIN (SELECT * FROM cx_FichaPagamentos WHERE idAbertura = '$idAbertura' AND flAtivo = '1') p ON f.idFormaPagamento = p.idFormaPagamento ".
			   "WHERE f.idTipo NOT IN ('6', '7', '9', '12') ".
			   "GROUP BY f.stFormaPagamento, f.idFormaPagamento ". 
	
			   "UNION ".
	
			   "SELECT SUM(c.vrPagamento) as Pagamento, f.stFormaPagamento, f.idFormaPagamento ".
			   "FROM cx_FormasPagamento f ".
			   "LEFT JOIN (SELECT * FROM cli_Pagamento WHERE idAbertura = '$idAbertura' AND flAtivo = '1') c ON f.idFormaPagamento = c.idFormaPagamento ".
			   "WHERE f.idTipo NOT IN ('6', '7', '9', '12') ".
			   "GROUP BY f.stFormaPagamento, f.idFormaPagamento ".
		   ") x ".
		   "GROUP BY stFormaPagamento, idFormaPagamento ".
	
		   "UNION ".
	
		   "SELECT NULL as vrPagamento, stFormaPagamento2, idFormaPagamento2, NULL as Pagamento2, SUM(Pagamento3) as vrPagamentoTotal ".
		   "FROM ".
		   "( ".
			   "SELECT SUM(d.vrDespesa) as Pagamento3, f.stFormaPagamento as stFormaPagamento2, f.idFormaPagamento as idFormaPagamento2 ".
			   "FROM cx_FormasPagamento f ".
			   "LEFT JOIN (SELECT * FROM cx_Despesas WHERE idAbertura = '$idAbertura' AND flAtivo = '1') d ON f.idFormaPagamento = d.idFormaPagamento ".
			   "WHERE f.idTipo NOT IN ('6', '7', '9', '12') ".
			   "GROUP BY f.stFormaPagamento, f.idFormaPagamento ".
		   ") k ".
		   "GROUP BY stFormaPagamento2, idFormaPagamento2 ".
	
		   "UNION ".
	
		   "SELECT NULL as vrPagamento, stFormaPagamento2, idFormaPagamento2, SUM(Pagamento2) as vrPagamento, SUM(Pagamento2) as vrPagamentoTotal ".
		   "FROM ".
		   "( ".
			   "SELECT SUM(s.vrSangria) as Pagamento2, f.stFormaPagamento as stFormaPagamento2, f.idFormaPagamento as idFormaPagamento2 ".
			   "FROM cx_FormasPagamento f ".
			   "LEFT JOIN (SELECT * FROM cx_Sangrias WHERE idAbertura = '$idAbertura' AND flAtivo = '1') s ON f.idFormaPagamento = s.idFormaPagamento ".
			   "WHERE f.idTipo NOT IN ('6', '7', '9', '12') ".
			   "GROUP BY f.stFormaPagamento, f.idFormaPagamento ".
		   ") y ".
		   "GROUP BY stFormaPagamento2, idFormaPagamento2 ".
	   ") w ".
	   "GROUP BY stFormaPagamento, idFormaPagamento";

$res = mssql_query($sql);

try{
    while ($arr = mssql_fetch_array($res)){
        $idFormaPagamento = "n".$arr['idFormaPagamento'];
        $idFormaPagamentoMicro = "x".$arr['idFormaPagamento'];

        if ($_POST[$idFormaPagamento] && $_REQUEST[$idFormaPagamentoMicro]){
            $Operador = $_COOKIE['idOperador'];
            $vrPagamento = $_REQUEST[$idFormaPagamento];
            $vrPagamento = strtr($vrPagamento, ",", ".");
            $vrPagamentoMicro = $_REQUEST[$idFormaPagamentoMicro];
            $vrPagamentoMicro = strtr($vrPagamentoMicro, ",", ".");

            mssql_query("INSERT INTO cx_GerenciadorDetalhes (idDetalhe, idAbertura, idFormaPagamento, vrPagamento, idOperador, vrPagamentoMicro) VALUES ('$idDetalhe', '$idAbertura', '".$arr['idFormaPagamento']."', '$vrPagamento', '$Operador', '$vrPagamentoMicro')");
            
        }
    }
     $qry = "INSERT INTO cx_historicoFechamento (idAbertura,vrApurado,vrFechamento,vrDiferenca,dtData) values ($idAbertura,$vrApurado,".$_REQUEST['vrFechamento'].",$vrDiferenca,getdate())";
                mssql_query($qry);
}catch(Exception $ex){
    $trans = false;
    // header("LOCATION: ../?sec=erro&sub=42");
    die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
}

try{
    $QUERYS = array(
                    "UPDATE cx_Gerenciador SET flConferencia = '1', vrTrocoEncerramento = '".strtr($vrTrocoEncerramento, ",", ".")."', vrFechamento = '".strtr($vrFechamento, ",", ".")."', stOBS = '".$stOBS."' WHERE idAbertura = ".$idAbertura,
                    "IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'cx_Gerenciador' AND COLUMN_NAME = 'dtAlteracao') UPDATE cx_Gerenciador SET dtAlteracao = GETDATE() WHERE idAbertura = ".$idAbertura
                   );
    foreach($QUERYS as $sql){
        if(!empty($sql) || !is_null($sql))
            @mssql_query ($sql);
    }
}catch(Exception $ex){
    $trans = false;
    // header("LOCATION: ../?sec=erro&sub=42");
    die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
}

if(!$chkAbrirRelatorio){
    insertLog("FECHAMENTO", "FECHAMENTO DO CAIXA [$idAbertura] REALIZADO.");
    // header("LOCATION: ../?sec=notificacao&sub=44");
    die(retornaJson(false, "Não foi Possível Iniciar o Inventário.<br><br>"));
    exit;
}else{
    if(!$trans){
        // header("LOCATION: ../?sec=erro&sub=42");
            rollback();
        die(retornaJson(false, "Ocorreu um erro ao tentar fazer o fechamento de caixa.<br><br>"));
    }
    else{
        insertLog("FECHAMENTO", "FECHAMENTO DO CAIXA [$idAbertura] REALIZADO.");
        commit();
        echo retornaJson(true, "Fechamento realizado com sucesso!<br><br>Redirecionando...", '?sec=relatorios&sub=fechamento&passo1=true&passo2=true&idab='.$idAbertura.'', 1000);
        // header("LOCATION: ../?sec=relatorios&sub=fechamento&passo1=true&passo2=true&idab=$idAbertura");
    }
}