<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

// var_dump($_GET);
$start = $_GET['start'];
$length = $_GET['length'];
$search = $_GET['search'];
$order = $_GET['order'][0];
if ($order) {
	$orderColumn = $order['column'];
	switch ($orderColumn) {
		case 0:
		$orderColumn = "p.idProduto";
		break;
		case 1:
		$orderColumn = "p.stProduto";
		break;
		case 2:
		$orderColumn = "t.stCategoria";
		break;
		case 3:
		$orderColumn = "m.stMedida";
		break;
		case 4:
		$orderColumn = "s.stSetor";
		break;
		case 5:
		$orderColumn = "p.vrUnitario";
		break;
		case 6:
		$orderColumn = "a.stAliquota";
		break;
	}
	$orderDirection = strtoupper($order['dir']);
}

if ($search) {
	$searchValue = $search['value'];
	$searchLength = strlen($searchValue);
}

//QUERY DE TOTAL DE PRODUTOS
$qry = "SELECT COUNT(DISTINCT idProduto)FROM prd_Produtos 
WHERE flAtivo = '0' AND idTipoProduto <> 7";
$res = mssql_fetch_array(mssql_query($qry));
$rows['recordsTotal'] = $res[0];


//QUERY DE TOTAL DE PRODUTOS FILTRADOS
$qry = "SELECT COUNT(DISTINCT idProduto)FROM prd_Produtos
WHERE flAtivo = '0' AND idTipoProduto <> 7 ";
if($searchLength > 0){
	$qry .= "AND stProduto LIKE '".$searchValue."%'";
}
$res = mssql_fetch_array(mssql_query($qry));
$rows['recordsFiltered'] = $res[0];


//QUERY DE BUSCA DE PRODUTOS
$qry = "DECLARE @page INT = ".($start/$length)."
DECLARE @perPage INT = ".$length."

SELECT stProduto, stCategoria, stMedida, stSetor, vrUnitario, stAliquota, idProduto FROM
(
	SELECT ROW_NUMBER() OVER (ORDER BY ".$orderColumn." ".$orderDirection.") AS RowNum, stProduto, m.stMedida, a.stAliquota, t.stCategoria, p.vrUnitario, p.idProduto, s.stSetor
	FROM prd_Produtos p
	INNER JOIN prd_Medidas m ON p.idMedida = m.idMedida 
	INNER JOIN prd_Categorias t ON p.idCategoria = t.idCategoria 
	INNER JOIN prd_SubCategorias b ON p.idSubCategoria = b.idSubCategoria AND t.idCategoria = b.idCategoria 
	INNER JOIN prd_Aliquotas a ON p.idAliquota = a.idAliquota 
	INNER JOIN prd_Setores s ON p.idSetor = s.idSetor 
	WHERE p.flAtivo = '0' AND p.idTipoProduto <> 7 ";
	if($searchLength > 0){
		$qry .= "AND p.stProduto LIKE '".$searchValue."%'";
	}
	$qry .= ") AS produtos WHERE RowNum >= (@page)* @perPage AND RowNum <= ((@page)* @perPage)+@perPage";

$res = mssql_query($qry);
while ($arr = mssql_fetch_assoc($res)) {
	$arr['stProduto'] = utf8_encode($arr['stProduto']);
	$arr['vrUnitario'] = number_format($arr['vrUnitario'],2, ",", ".");
	$data[] = $arr;
}
if (!$data) {
	$rows['data'] = array();	
}else{
	$rows['data'] = $data;
}

echo json_encode($rows);
?>