<?php
ob_start();
ini_set("memory_limit", "512M");
require_once "../../functions.php";
db_conn();

$objDados = (object) $_GET;

$sql_cliente = "SELECT TOP(1) c.stCliente, ce.stEndereco, c.nrNumero, ce.stBairro, ce.stCidade, ce.stEstado, ce.stCEP
                FROM dlv_Clientes c
                LEFT JOIN dlv_CEPs ce
                ON c.idCEP = ce.idCEP
                WHERE c.idCliente = ".$objDados->idcliente;

$sql_produtos = "SELECT MIN(D.idCodigo) AS idCodigo, I.idAbertura, I.idExtrato, I.idItem, P.stProduto, M.stMedida, M.flFracionado, I.dtData, I.nrQuantidade, I.vrUnitario, A.vrAliquota, I.vrTotal, P.vrUnitario AS vrUnitarioAtual ".
                "FROM cli_ItemExtrato I ".
                "INNER JOIN cli_Extrato E ON I.idExtrato = E.idExtrato AND I.idAbertura = E.idAbertura ".
                "INNER JOIN dlv_Clientes C ON E.idCliente = C.idCliente ".
                "INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto ".
                "INNER JOIN prd_Codigos D ON P.idProduto = D.idProduto ".
                "INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida ".
                "INNER JOIN prd_Aliquotas A ON P.idAliquota = A.idAliquota ".
                "WHERE E.idCliente = ".$objDados->idcliente." AND E.idFatura = ".$objDados->idfatura." AND I.flAtivo = '1' AND C.flAtivo = 1 ".
                "GROUP BY I.idAbertura, I.idExtrato, I.idItem, P.stProduto, M.stMedida, M.flFracionado, I.dtData, I.nrQuantidade, i.vrUnitario, A.vrAliquota, I.vrTotal, P.vrUnitario";

$sql_desconto = "SELECT SUM(vrDesconto) as desconto FROM cli_Extrato WHERE idCliente = ".$objDados->idcliente." AND idFatura = ".$objDados->idfatura;

$Cliente = mssql_fetch_object(mssql_query($sql_cliente));

$tbl_cliente = 
"
<h2 style=\"text-align: center;\">Fatura de Cliente</h2>
<center style=\"text-align: center;\"><span><b>Data de Emissão:</b> ".date("d/m/Y H:i:s")."h</span></center>  
<br />
<table>
    <tbody>
        <tr>
            <td style=\"text-align: right;\"><b>Cliente:</b></td>
            <td>".$Cliente->stCliente."</td>
        </tr>
        <tr>
            <td style=\"text-align: right;\"><b>Endereço:</b></td>
            <td>".$Cliente->stEndereco.",".$Cliente->nrNumero." - ".$Cliente->stBairro." - ".$Cliente->stCidade.",".$Cliente->stEstado."</td>
        </tr>
        <tr>
            <td style=\"text-align: right;\"><b>CEP:</b></td>
            <td>".$Cliente->stCEP."</td>
        </tr>
    </tbody>
</table>
";

$tbl_produtos = 
"
    <h3 style=\"text-align: center;\">Lista de Produtos</h3>
<table>
    <thead>
        <tr style=\"background-color: #CCCCCC;\">
            <th>Cod.</th>
            <th>Produto</th>
            <th>Dt. Venda.</th>
            <th>Qnt.</th>
            <th>Vlr. Un.</th>
            <th>TTL. R$</th>
        </tr>
    </thead>
    <tbody>";

$objResource = mssql_query($sql_produtos);
$i = 0;
$subtotal = (float) 0;
while($Prod = mssql_fetch_object($objResource)){
    $qnt = ($Prod->flFracionado ? (number_format(($Prod->nrQuantidade / 1000), 3, ',', '.')) : (int) $Prod->nrQuantidade);
    $tbl_produtos .= 
    "
        <tr style=\"background-color: ".($i++&1 ? '#F0F0F0' : '')."\" >
            <td style=\"text-align: center;\">".$Prod->idCodigo."</td>
            <td style=\"text-align: center;\">".$Prod->stProduto."</td>
            <td style=\"text-align: center;\">".date("d/m/Y", strtotime($Prod->dtData))."</td>
            <td style=\"text-align: center;\">".$qnt." ".$Prod->stMedida."</td>
            <td style=\"text-align: right;\">".number_format($Prod->vrUnitario, 2, ',', '.')."</td>
            <td style=\"text-align: right;\">".number_format($Prod->vrTotal, 2, ',', '.')."</td>
        </tr>
    ";
    $subtotal += $Prod->vrTotal;
}
$Venda = mssql_fetch_object(mssql_query($sql_desconto));
$tbl_produtos .= 
"
    <tr style=\"background-color: #CCCCCC;\">
        <td style=\"text-align: right;\"><b>Subtotal R$</b></td>
        <td colspan=\"6\" style=\"text-align: right;\">".number_format($subtotal, 2, ',', '.')."</td>
    </tr>
    <tr style=\"background-color: #CCCCCC;\">
        <td style=\"text-align: right;\"><b>Desconto R$</b></td>
        <td colspan=\"6\" style=\"text-align: right;\">".number_format($Venda->desconto, 2, ',', '.')."</td>
    </tr>
    <tr style=\"background-color: #CCCCCC;\">
        <td style=\"text-align: right;\"><b>Total R$</b></td>
        <td colspan=\"6\" style=\"text-align: right;\">".number_format(($subtotal + $Venda->desconto), 2, ',', '.')."</td>
    </tr>
";

$tbl_produtos .= "</tbody></table>";
$header = '<div style="font-size: 10px; text-align: right;">NATI Retaguarda, {DATE d/m/Y} pag. {PAGENO} de {nb}</div>';
$footer = '<div style="font-size: 10px; text-align: center;">© 2001 - '.date("Y").', Arcnet Automação Comercial. Todos os direitos reservados.</div>';

$objPdf = new \Mpdf\Mpdf();
//$objPdf = new mPDF();
$objPdf->SetHTMLHeader($header);
$objPdf->WriteHTML($tbl_cliente);
$objPdf->WriteHTML($tbl_produtos);
$objPdf->SetHTMLFooter($footer);
$objPdf->Output('fatura_cliente.pdf', 'D');//download forçado
//$objPdf->Output('fatura_cliente.pdf', 'I');//visualização na tela
exit();