<?php

require_once "functions.php";

logincheck();

if (autorization(57) == false)
{
    ?>
    <SCRIPT>
      document.location = "?sec=erro&sub=2";
    </SCRIPT>
    <?
    die;
}

$actualDate = date('d/m/Y');
$partes = explode("/", $actualDate);
$startDate = '01/' . $partes[1] . "/" . $partes[2];

?>
<div class="container" id="app">
    <br/>
    <div class="col-md-12">
        <h3>Vendas por Cliente</h3>
        <hr>
    </div>
    <div id="filter-panel">
        <div class="panel panel-default">
            <div class="panel-body">
                <div class="form-group col-md-6">
                    <div class="input-group">
                        <div class="input-group-addon">De:</div>
                        <input type="text" name="datepicker" id="de" value='<?php echo  $startDate ?>' class="form-control data"/>
                        <div class="input-group-addon">Até:</div>
                        <input type="text" name="datepicker" id="ate"  value='<?php echo  $actualDate ?>' class="form-control data"/>
                    </div>
                </div>
                <div class="form-group col-md-4">
                    <select class="form-control" name="selectClientes" id="selectClientes">
                        <option value="">Selecione um Cliente</option>
                    </select>
                </div>
                <div class="form-group col-md-2">
                    <a class="btn btn-primary" onclick="getData()">
                        <span class="glyphicon glyphicon-search"></span> Buscar
                    </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="panel" id="conteudo-empty" hidden>
                <div class="alert alert-warning col-md-10 col-md-offset-1" role="alert">
                    <h4 class="text-center">Nenhum resultado foi encontrado para o periodo selecionado!</h4>
                </div>
            </div>
            <div class="panel" id="conteudo" hidden>
                <div class="panel panel-body">
                    <h4>Cliente: <span id="spnCliente"></span></h4>
                    <table id="dtVendasClientes" width="100%" class="display table table-striped table-bordered" cellspacing="0" cellpadding="3" >
                        <thead>
                        <tr bgcolor="#2A98D3">
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Data</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Codigo</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Produto</b></span></th>
                            <th class="text-center"><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Medida</b></span></th>
                            <th class="text-center"><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Qtd</b></span></th>
                            <th class="text-center"><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Valor Total</b></span></th>
                        </tr>
                        </thead>
                        <tbody id="relTable"></tbody>
                        <tfoot>
                        <tr>
                            <td colspan="6" class="text-right">
                                <b> R$ <span id="vrTotal"></span></b>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-loader"></div>
    </div>
</div>

<script src="js/jquery-2.1.4.js"></script>
<script src="js/bootstrap.min.js"></script>

<style>
    .dataTables_wrapper .dt-buttons {
        float:none;
        text-align:right;
        margin-bottom: 6px;
    }

</style>
<script>


    // Vue.use(BootstrapVue)
    //
    // new Vue({
    //     el: '#app',
    //     data:{
    //         startOfMonth: '',
    //         endOfMonth: ''
    //     },
    //     created() {
    //         console.log('Vue from legacy');
    //         this.startOfMonth = moment().startOf('month').format('DD/MM/YYYY');
    //         this.endOfMonth   = moment().format('DD/MM/YYYY');
    //     }
    // });

  $(document).ready(function(){
    $("#conteudo-empty").hide();
    $("[name='datepicker']").change(function () {
      loadSelectCliente();
    });
    setDateFields();
    loadSelectCliente();
  });

  function initDataTable() {
    $('#dtVendasClientes').DataTable({
      "searching": false,
      "paging": false,
      "info": false,
      "destroy": true,
      "dom": 'Bfrtip',
      "buttons": ['excel', 'copy', 'print']
    });
  }

  function loadSelectCliente(){
    data = {
      action: 'listaClientes',
      dataInicial: $('#de').val(),
      dataFinal: $('#ate').val()
    };
    var option = '';
    $.post('relatorios/resources/php/relatorioVendas.php', data, function(response) {
      if (response.length == 0)
      {
        $("#conteudo-empty").show();
        $('#conteudo').hide();
      }
      else
      {
        $("body").addClass("loading");
        $("#conteudo-empty").hide();
        for (var i = 0; i < response.length; i++) {
          var res = response[i];
          option += '<option value="'+ res['idCliente']+'">'+ res['stCliente'].substring(0,35)+'</option>';
        }
        $(option).appendTo($('#selectClientes'));
        $("body").removeClass("loading");
      }
    });
  }

  function getData() {
    $('#relTable').empty();
    $("#conteudo").hide();

    var idCliente =  $('#selectClientes').val();
    $("body").addClass("loading");
    if (idCliente != '') {
      data = {
        action: 'vendasPorCliente',
        dataInicial: $('#de').val(),
        dataFinal: $('#ate').val(),
        idCliente: idCliente
      };

      $.post('relatorios/resources/php/relatorioVendas.php', data, function(response) {
        var linha = '';
        var valorTotal = 0.;
        var itens = response['itens'];

        for(var x = 0; x < itens.length; x++)
        {
          var it = itens[x];
          linha += '<tr>';
          linha += '<td>' + it['data'] + '</td>';
          linha += '<td>' + it['idCodProduto'] + '</td>';
          linha += '<td>' + it['stProduto'] + '</td>';
          linha += '<td class="text-center">' + it['stMedida'] + '</td>';
          linha += '<td>' + it['nrQuantidade'] + '</td>';
          linha += '<td class="text-right">' + it['vrTotal'] + '</td>';
          linha += '</tr>';
          valorTotal += parseFloat(it['vrTotal']);
        }
        $("#spnCliente").text(response['cliente']);
        $('#vrTotal').text(valorTotal.toFixed(2));
        $(linha).appendTo($('#relTable'));
        $("body").removeClass("loading");
        $("#conteudo").show();
        initDataTable();
      });
    } else {

      $("body").removeClass("loading");
      $('#relTable').html('');
      $("#conteudo").hide();
      sweetAlert('Atenção', 'Selecione um cliente para continuar!', 'error');
    }
    $("body").removeClass("loading");

  }
</script>
