<?php

namespace App\Console\Commands;

use App\Exports\Nati\ProductsIntegracaoControllerExport;
use Illuminate\Console\Command;
use Maatwebsite\Excel\Facades\Excel;

class ExportProducts extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'export:products';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Exporta cadastro de produto para C:laragon';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $this->info("Gerando arquivo de exportação. Isto pode demorar um pouco...");
        $name = "prod_export_";
        $name .= time() . '_' . rand();
        $name .= ".csv";

        Excel::store(new ProductsIntegracaoControllerExport, $name);

        $this->info("Arquivo salvo em " . storage_path() . '\\app\\' . $name );
    }
}
