<?php


namespace App\Entities\Delivery;


use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Payment extends Model
{
    protected $table = 'dlv_FichaPagamentos';
    protected $primaryKey = ['idFicha', 'idAtendimento'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idFicha',
        'idAtendimento',
        'idFormaPagamento',
        'vrFormaPagamento',
        'dtData',
        'flTroco',
        'flAtivo',
        'dtAlteracao',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        $this->flTroco = false;
        $this->flAtivo = true;
    }

    public function setDtDataAttribute($value)
    {

        $this->attributes['dtData'] = Carbon::parse($value)->timezone('America/Sao_Paulo');
    }

    public function setDtAlteracaoAttribute($value)
    {
        $this->attributes['dtAlteracao']= Carbon::parse($value)->timezone('America/Sao_Paulo');
    }

    public function setId($idAtendimento)
    {
        $this->idAtendimento = $idAtendimento;
        $this->idFicha = $this->getNextId($idAtendimento);
    }

    private function getNextId($idAbertura)
    {
        return Payment::where('idAtendimento', $idAbertura)->max('idFicha') + 1;
    }

    public function order()
    {
        return $this->belongsToMany(Order::class);
    }

//    public function paymentMethod(){
//        return $this->hasOne();
//    }

}
