<?php


namespace App\Entities\Delivery;


use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Passport\HasApiTokens;
use Prettus\Repository\Traits\TransformableTrait;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens;
    use Notifiable;
    use TransformableTrait;

//

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $table = 'op_Operadores';
    protected $primaryKey = 'idOperador';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idOperador',
        'stApelido',
        'stNome',
        'stSenha',
        'nrAcessos',
        'stEmail',
        'stNome',
        'dtUltimoacesso',
        'flAtivo',
        'stTelefone1',
        'stTelefone2',
        'stRg',
        'stEndereco',
        'stCargo',
        'dtAdmissao',
        'stCartao',
        'nrPontos',
        'dtAlteracao',
        'idPerfil',
    ];

    protected $casts = [
        'flAtivo' => 'boolean'
    ];


    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [
            'name' => $this->stApelido,
            'rules' => []
        ];
    }
}
