<?php

namespace App\Entities\Nati;

use App\Entities\Supplier;
use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class FichaFornecedor extends Model implements Transformable
{
    use TransformableTrait;
//    //    use HasCompositePrimaryKey;

    protected $table = 'frn_FichaFornecedor';
    protected $primaryKey = ['idFornecedor', 'idProduto'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idFornecedor',
        'idProduto',
        'idCategoria',
        'codProdutoF',
        'stDescProdF',
        'dtLastSale',
        'dtFirstSale',
        'vrLastSale',
        'dtAlteracao',
        'produto',
        'vrFirstSale'
    ];

    protected $maps = [
        'product_name' => 'produto.description',
        'code_ean' => 'produto.code_ean'
    ];

    protected $appends = [
        'product_name',
        'code_ean',
    ];

    public function fornecedor()
    {
        return $this->hasOne(Supplier::class, 'idFornecedor', 'idFornecedor');
    }

    public function produto()
    {
        return $this->hasOne(Product::class, 'idProduto', 'idProduto');
    }
}
