<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class StockMovimentation.
 *
 * @package namespace App\Entities;
 */
class StockMovimentation extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'est_Movimentacoes';
    protected $primaryKey = ['idMovimentacao', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idMovimentacao',
        'idAbertura',
        'idOrigem',
        'idDestino',
        'dtMovimentacao',
        'stOperador',
        'stNotaFiscal',
        'flEntrada',
        'flTipoOrigem',
        'flTipoDestino',
        'flAtivo',
        'vrEncargos',
        'stObservacao',
        'dtData',
        'flTipoEstoque',
        'dtAlteracao',
    ];

    protected $casts = [
        'flEntrada' => 'boolean',
        'flTipoOrigem' => 'boolean',
        'flTipoDestino' => 'boolean',
        'flAtivo' => 'boolean',
        'flTipoEstoque' => 'boolean',
    ];

    public function itens()
    {
        return $this->hasMany(StockItemsMovimentation::class, 'idMovimentacao', 'idMovimentacao');
    }
}
