<?php


namespace App\Http\Controllers\Delivery;


use App\Entities\Delivery\DlvConfig;
use App\Entities\Nati\Customer;
use App\Repositories\PontoDeliveryRepository;
use Illuminate\Http\Request;

class ConfigController
{
    protected $service;
    protected $repository;

    public function __construct(PontoDeliveryRepository $repository)
    {
        $this->repository = $repository;
    }

    public function index(Request $request)
    {
        try {
            $ip = $_SERVER['REMOTE_ADDR'];
            $response = DlvConfig::find($ip);
            return response()->json($response);

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function update(Request $request, $id)
    {
        $ip = $_SERVER['REMOTE_ADDR'];
        return $this->repository->update($request->all(), $ip);
    }
}
