<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\MicroTerminalService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Nati\MicroTerminalCreateRequest;
use App\Http\Requests\Nati\MicroTerminalUpdateRequest;


class MicroTerminalController extends Controller
{

   protected $service;

    public function __construct(MicroTerminalService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        try
        {
            $microterminais = $this->service->all();

            return response()->json($microterminais);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  MicroTerminalCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(MicroTerminalCreateRequest $request)
    {
        try {
            $microterminal = $this->service->create($request->all());

            $microTerminal = [
                'message' => 'MicroTerminal created.',
                'data'    => $microterminal,
            ];
            return response()->json($microTerminal, 201);

        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        try
        {
            $microterminal = $this->service->getById($id);

            return response()->json($microterminal);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function update(MicroTerminalUpdateRequest $request, $id)
    {
        try {
            $this->service->update($request->all(), $id);

            $response = [
                'message' => 'MicroTerminal created.'
            ];

            return response()->json($response, 201);

        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        try {
            $microterminal = $this->service->delete($id);
            $response = [
                'message' => 'MicroTerminal deleted.',
                'data'    => $microterminal,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
