<?php

namespace App\Http\Controllers;

use App\Entities\Logs;
use App\Http\Requests\Nati\SectorUpdateRequest;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Http\Requests\Nati\SectorCreateRequest;
use App\Services\Nati\SectorService;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Entities\Nati\Sector;


class SectorsController extends Controller
{

    protected $service;

    public function __construct(SectorService $service)
    {
        $this->service  = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request)
    {
        try
        {
            $setores = $this->service->all($request->all());

            return response()->json($setores);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }
    public function getAll()
    {
        try
        {
            $setores = $this->service->getAll();

            return response()->json($setores);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param SectorCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(SectorCreateRequest $request)
    {
        try {
            $user = auth()->user();
            $setor = $this->service->create($request->all());
            Logs::writeLog($user->stApelido, "SETORES", 'O USUARIO [' . $user->stApelido . '] CADASTROU O SETOR [' . $setor->stSetor . ']');

            $response = [
                'message' => 'Setor created.',
                'data'    => $setor->toArray(),
            ];
            return response()->json($response, 201);

        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return JsonResponse
     */
    public function show($id)
    {
        try
        {
            $setor = $this->service->getById($id);

            return response()->json($setor);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  SectorUpdateRequest $request
     * @param  string            $id
     *
     * @return JsonResponse
     */
    public function update(SectorUpdateRequest $request, $id)
    {
        try {
            $oldNameSector = Sector::where('idSetor', $id)->first();
            $user = auth()->user();
            $response = $this->service->update($request->all(), $id);

            Logs::writeLog($user->stApelido, "SETORES", 'O USUARIO [' . $user->stApelido . '] ALTEROU NOME DO SETOR DE [' . $oldNameSector->stSetor . '] ' . 'PARA [' . $response->stSetor . ']');
            return response()->json([
                'message' => 'Setor Update',
                'data' => $response
            ],201);


        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 404);
        } catch (\Exception $e){
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $user = auth()->user();
            $setor = $this->service->delete($id);
            Logs::writeLog($user->stApelido, "SETORES", 'O OPERADOR [' . $user->stApelido . '] DESATIVOU O SETOR [' . $setor->stSetor . ']');

            $response = [
                'message' => 'Setor deleted.',
                'data'    => $setor,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
