<?php

namespace App\Observers;

use App\Entities\Nati\FormaPagamento;
use Illuminate\Support\Facades\Cache;

class FormaPagamentoObserver
{
    /**
     * Handle the forma pagamento "created" event.
     *
     * @param  FormaPagamento  $formaPagamento
     * @return void
     */
    public function created(FormaPagamento $formaPagamento)
    {
        Cache::tags(['ListaFormaPagamento'])->flush();
    }

    /**
     * Handle the forma pagamento "updated" event.
     *
     * @param  FormaPagamento  $formaPagamento
     * @return void
     */
    public function updated(FormaPagamento $formaPagamento)
    {
       Cache::tags(['ListaFormaPagamento'])->flush();
    }

    /**
     * Handle the forma pagamento "deleted" event.
     *
     * @param  FormaPagamento  $formaPagamento
     * @return void
     */
    public function deleted(FormaPagamento $formaPagamento)
    {
       Cache::tags(['ListaFormaPagamento'])->flush();
    }

    /**
     * Handle the forma pagamento "restored" event.
     *
     * @param  FormaPagamento  $formaPagamento
     * @return void
     */
    public function restored(FormaPagamento $formaPagamento)
    {
       Cache::tags(['ListaFormaPagamento'])->flush();
    }

    /**
     * Handle the forma pagamento "force deleted" event.
     *
     * @param  FormaPagamento  $formaPagamento
     * @return void
     */
    public function forceDeleted(FormaPagamento $formaPagamento)
    {
       Cache::tags(['ListaFormaPagamento'])->flush();
    }
}
