<?php


namespace App\Reports;


use App\Entities\Nati\Customer;
use \koolreport\processes\Group;
use \koolreport\processes\Sort;
use \koolreport\processes\Limit;

class SalesByCustomer extends \koolreport\KoolReport
{
    use \koolreport\laravel\Friendship;

//    function settings()
//    {
//        return array(
//            "dataSources"=>"sqlsrv");
//    }

    function setup()
    {
        // Let say, you have "sale_database" is defined in Laravel's database settings.
        // Now you can use that database without any futher setitngs.
        $this->src("sqlsrv")
            ->query('
                select * from cx_vendas_temp v
                inner join dlv_clientes c on c.idCliente = v.idCliente
                where v.flAtivo = 1

                ')
            ->pipe(new Group(['by'=> 'stCliente', 'sum'=>'vrTotal']))
            ->pipe(new Sort(array(
                "vrTotal"=>"desc"
            )))
            ->pipe($this->dataStore("sales_by_customer"));
    }
}
