<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\RespostaObservacaoRepository;
use App\Entities\RespostaObservacao;
use App\Validators\RespostaObservacaoValidator;

/**
 * Class RespostaObservacaoRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class RespostaObservacaoRepositoryEloquent extends BaseRepository implements RespostaObservacaoRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return RespostaObservacao::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return RespostaObservacaoValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
