<?php
/**
 * Created by PhpStorm.
 * User: clecio
 * Date: 14/06/2017
 * Time: 10:29
 */
namespace App\Services;

use App\Entities\Financeiro\Bandeira;
use App\Repositories\BandeiraRepository;
use App\Validators\BandeiraValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class BandeiraService extends Service {

    private $repository;
    private $validator;

    public function __construct(BandeiraRepository $repository, BandeiraValidator $validator) {

        $this->repository = $repository;
        $this->validator = $validator;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
    }

    public function get() {

        return $this->repository->all();
    }

    public function getById($id) {

        return $this->repository->find($id);
    }

    public function insert($request) {

        $bandeira = [
            "idBandeira" => $this->nextId(),
            "stBandeira" => $request['stBandeira'],
            "dtAlteracao" => Carbon::now(),
            "vrPorcentagemJuros" => $request['vrPorcentagemJuros'],
            "flCredito" => 0,
            "vrTaxaCredito" => $request['vrTaxaCredito'],
            "vrTaxaDebito" => $request['vrTaxaDebito'],
        ];

        $this->validator->with($bandeira)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($bandeira);
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        return $this->repository->delete($id);
    }

    private function nextId()
    {
        return Bandeira::max('idBandeira') + 1;
    }

}
