<?php

namespace App\Services\Delivery;

use App\Entities\Delivery\CEP;
use App\Entities\Delivery\CouponPrint;
use App\Entities\Delivery\DlvConfig;
use App\Entities\Delivery\Item;
use App\Entities\Delivery\Order;
use App\Entities\Delivery\Payment;
use App\Entities\Delivery\Phone;
use App\Entities\Delivery\Prints;
use App\Entities\Master;
use App\Entities\Nati\Customer;
use App\Entities\Nati\FichaTecnica;
use App\Entities\Nati\Impressora;
use App\Entities\Nati\Product;
use App\Entities\PontoDelivery;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Entities\Mobyo\Integration;

class PrintService
{
    function printCoupon($id, $name = 'Ifood', $budget = false, $integrationSettings = null)
    {
        $date = Carbon::now();
        $master = Master::first();
        if($integrationSettings) {
            $config = DlvConfig::find($integrationSettings->idDeliveryPadrao);
        } else {
            $config = DlvConfig::find($_SERVER['REMOTE_ADDR']);
        }


        if ($config->stMarcaPrint == "SEM IMPRESSORA") throw new \Exception("Não há nenhuma impressora configurada para este ponto de delivery");

        $EXPAND = $this->expand($config->stMarcaPrint);
        $COMPRESS = $this->compress($config->stMarcaPrint);
        $totalLines = 48;
        $dottedLine = "------------------------------------------------";
        $stRodapeCupom = "OBRIGADO E VOLTE SEMPRE";

        $order = Order::find($id);

        $body = "";

        if ($config->stMarcaPrint == "DARUMA") {

            $body = chr(27) . "@";
        }

        if ($config->stMarcaPrint == "EPSON_T20") {
            $totalLines = 56;
            $dottedLine = "--------------------------------------------------------";
        }

        //Header
        $aux = intval(($totalLines - strlen($master->stCliente)) / 2);
        $body = str_pad($body, strlen($body) + $aux);

        $auxHeader = $master->stEndereco . (strlen(trim($master->stBairro)) > 0 ? " - " . $master->stBairro : "");

        $aux = (($totalLines - strlen($auxHeader)) / 2);
        $body = str_pad($body, strlen($body) + $aux);
        $body .= $auxHeader . chr(10);

        $auxHeader = $master->stTelefone1 . (strlen(trim($master->stTelefone2)) > 0 ? " / " . $master->stTelefone2 : "");
        $aux = (($totalLines - strlen($auxHeader)) / 2);
        $body = str_pad($body, strlen($body) + $aux);

        $body .= $auxHeader . chr(10);
        $aux = ($totalLines - strlen($master->stMarketing)) / 2;
        $body = str_pad($body, strlen($body) + $aux);
        $body .= $master->stMarketing . chr(10);
        //End Header

        // Verifica se tem Orçamento
        if ($budget) {
            $body .= $dottedLine . chr(10);
            $body .= $EXPAND . "     # ORCAMENTO #" . $COMPRESS . chr(10);
        }

        //Verifica se o cliente vai retirar este pedido
        if ($order->flClienteRetira) {
            $body .= $dottedLine . chr(10);
            $body .= $EXPAND . "   # CLIENTE RETIRA #" . $COMPRESS . chr(10);
        } else {
            $body .= $dottedLine . chr(10);
            $body .= $EXPAND . "      # DELIVERY #" . $COMPRESS . chr(10);
        }

        $body .= $dottedLine . chr(10);
        $body .= "ATENDENTE: ";
        $body .= $name;

        $num = $config->stMarcaPrint == "EPSON_T20" ? 19 : 18 - strlen($name);

        for ($x = 0; $x < $num; $x++) {
            $body .= " ";
        }

        $body .= $date->format("d/m/Y") . chr(10);
        $body .= $dottedLine . chr(10);

        //DADOS DO CLIENTE
        if (intval($order->nrPedido) > 0) {
            $body .= "PEDIDO: ";
            $body .= $id . chr(10);

            if (!$budget) {
                $body .= $EXPAND . "CONTROLE: " . $COMPRESS;
                $body .= $EXPAND . $order->nrPedido . $COMPRESS . chr(10);
            }
        } else {
            $body .= $EXPAND . "PEDIDO: " . $COMPRESS;
            $body .= $EXPAND . $id . $COMPRESS . chr(10);
        }

        $aux = $order->dtAbertura;
        $body .= "DATA DO PEDIDO: " . Carbon::createFromFormat("Y-m-d H:i:s", $order->dtAbertura)->format('d/m/Y H:i') . chr(10);

        if ($order->flAgendarPedido) {
            $body .= $EXPAND ."AGENDADO PARA: " . $COMPRESS;
            $body .= $EXPAND . Carbon::createFromFormat("Y-m-d H:i:s", $order->dtAgendarPedido)->format('d/m/Y H:i'). $COMPRESS . chr(10);
        }

        $costumer = Customer::find($order->idCliente);
        $body .= "CLIENTE: ";
        $body .= substr($costumer->stCliente, 0, 39) . chr(10);

        $cep = CEP::find($costumer->idCEP);

        $body .= "RUA: ";
        $body .= substr($cep->stEndereco, 0, 43) . chr(10);
        $body .= "NUMERO: ";
        $body .= $costumer->nrNumero . chr(10);
        $body .= "BAIRRO: ";
        $body .= substr($cep->stBairro, 0, 40) . chr(10);

        if (strlen(trim($costumer->stComplemento)) > 0) {
            $body .= "COMPLEMENTO: ";
            $body .= $costumer->stComplemento . chr(10);
        }
        if (strlen(trim($order->stOBS)) > 0) {
            $body .= "OBS: ";
            $body .= $order->stOBS . chr(10);
        }

        if (strlen(trim($costumer->stOBSDelivery))) {
            $body .= "OBS ENTREGA: ";
            $body .= $costumer->stOBSDelivery . chr(10);
        }

        $tels = Phone::where(['idCliente' => $costumer->idCliente])->get();
        $c = 0;
        foreach ($tels as $tel) {
            if ($c == 0) {
                $body .= "TELEFONE: ";
                $body .= "(" . substr($tel->nrTelefone, 0, 2) . ") " . substr($tel->nrTelefone, 2, strlen($tel->nrTelefone)) . ($tel->nrRamal > 0 ? " RAMAL: " . $tel->nrRamal : "") . chr(10);
                $c++;
            } else {
                $body .= "          ";
                $body .= "(" . substr($tel->nrTelefone, 0, 2) . ") " . substr($tel->nrTelefone, 2, strlen($tel->nrTelefone)) . ($tel->nrRamal > 0 ? " RAMAL: " . $tel->nrRamal : "") . chr(10);
            }
        }
        // FIM DADOS DO CLIENTE

        $body .= $dottedLine . chr(10);

        //LISTA DE PRODUTOS
        $products = Item::select(DB::raw('MIN(prd_Codigos.idCodigo) AS idCodigo,
                dlv_Itens.nrQuantidade,
                prd_Produtos.stProdutoAbreviado,
                dlv_Itens.vrTotal,
                dlv_Itens.vrUnitario,
                prd_Produtos.idProduto,
                dlv_Itens.stOBS,
                prd_Medidas.flFracionado,
                prd_Medidas.stMedida,
                dlv_Itens.stValores,
                dlv_Itens.stCodigos,
                dlv_Itens.stQuantidades'))
            ->join('prd_Produtos', 'dlv_Itens.idProduto', '=', 'prd_Produtos.idProduto')
            ->join('prd_Codigos', 'prd_Produtos.idProduto', '=', 'prd_Codigos.idProduto')
            ->join('prd_Medidas', 'prd_Produtos.idMedida', '=', 'prd_Medidas.idMedida')
            ->where(['dlv_Itens.idAtendimento' => $id])
            ->groupBy('dlv_Itens.nrQuantidade',
                'prd_Produtos.stProdutoAbreviado',
                'dlv_Itens.vrTotal',
                'dlv_Itens.vrUnitario',
                'prd_Produtos.idProduto',
                'dlv_Itens.stOBS',
                'prd_Medidas.flFracionado',
                'prd_Medidas.stMedida',
                'dlv_Itens.stValores',
                'dlv_Itens.stCodigos',
                'dlv_Itens.stQuantidades',
                'dlv_Itens.nrItem')
            ->orderBy('dlv_Itens.nrItem')
            ->get();

        $vrTotal = 0;

        foreach ($products as $product) {
            //PRODUTO FRACIONADO
            if ($product->flFracionado)
                $body .= number_format($product->nrQuantidade, 3, ".", "") . " " . $product->stMedida . chr(10);
            else
                $body .= intval($product->nrQuantidade) . " " . $product->stMedida . chr(10);

            //CODIGOS
            if (count(explode("@", $product->stCodigos)) > 1) {
                $codes = explode("@", $product->stCodigos);
                $stQuantidades = explode("@", $product->stQuantidades);

                $qtdCod = count($codes);
                $count = 0;
                $lastPiece = "";
                foreach ($codes as $code) {
                    $prod = Product::find($code);
                    $body .= $stQuantidades[0] . " " . $prod->stProdutoAbreviado . (($count + 1) < $qtdCod ? chr(10) : "");
                    $count++;
                    $lastPiece = $stQuantidades[0] . " " . $prod->stProdutoAbreviado;
                }
                $aux = (26 - strlen($lastPiece)) + (11 - strlen("R$ " . number_format($product->vrUnitario, 2, ",", ".")));
                $body = str_pad($body, strlen($body) + $aux, ' ');
                $body .= "R$ " . number_format($product->vrUnitario, 2, ",", ".");

                $aux = 11 - strlen("R$ " . number_format($product->vrTotal, 2, ",", "."));
                $body = str_pad($body, strlen($body) + $aux, ' ');
                $body .= "R$ " . number_format($product->vrTotal, 2, ",", ".");
                $body .= chr(10);
            } else {
                $stProdutoAbreviado = $product->nrQuantidade == (-100) ? "TAXA DE ENTREGA" : $product->stProdutoAbreviado;
                $body .= substr($stProdutoAbreviado, 0, 26);

                $aux = $config->stMarcaPrint == "EPSON_T20" ? 21 : 26 - strlen(substr($stProdutoAbreviado, 0, 26));
                $aux += 11 - strlen("R$ " . number_format($product->vrUnitario, 2, ",", "."));
                $body = str_pad($body, strlen($body) + $aux, ' ');
                $body .= "R$ " . number_format($product->vrUnitario, 2, ",", ".");

                $aux = 11 - strlen("   R$ " . number_format($product->vrTotal, 2, ",", "."));
                $body = str_pad($body, strlen($body) + $aux, ' ');
                $body .= "   R$ " . number_format($product->vrTotal, 2, ",", ".");
                $body .= chr(10);
            }

            if (strlen(trim($product->stOBS)) > 0) $body .= "OBS: " . $product->stOBS . chr(10);

            $body .= $dottedLine . chr(10);

            $vrTotal += $product->vrTotal;
        }
        //FIM DA LISTA DE PRODUTOS

       $discount = Order::select('desconto')
           ->where('idAtendimento', $id)
           ->get()
           ->first();

       if($discount->desconto > 0) {
           $vrTotal = $vrTotal - $discount->desconto;

           $body .= "Desconto";
           $aux = ($totalLines - (11 + strlen(number_format($discount->desconto, 2, ",", "."))));
           $body = str_pad($body, strlen($body) + $aux, '.');
           $body .= "R$ " . number_format($discount->desconto, 2, ",", ".") . chr(10);
           $body .= $dottedLine . chr(10);
       }

        $body .= "TOTAL";
        $aux = ($totalLines - (8 + strlen(number_format($vrTotal, 2, ",", "."))));
        $body = str_pad($body, strlen($body) + $aux, '.');
        $body .= "R$ " . number_format($vrTotal, 2, ",", ".") . chr(10);
        $body .= $dottedLine . chr(10);

        $flContaAssinada = false;
        //VERIFICA SE TEM ORÇAMENTO
        if (!$budget) {
            //FORMA DE PAGAMENTO
            $payments = Payment::select(['cx_FormasPagamento.*', 'cx_FormasPagamento.stFormaPagamento', 'cx_FormasPagamento.idTipo', 'dlv_FichaPagamentos.vrFormaPagamento'])
                ->join('cx_FormasPagamento', 'dlv_FichaPagamentos.idFormaPagamento', '=', 'cx_FormasPagamento.idFormaPagamento')
                ->where(["idAtendimento" => $id, "cx_FormasPagamento.flTroco" => false])
                ->get();

            foreach ($payments as $payment) {
                $body .= $payment->stFormaPagamento;
                $aux = ($totalLines - (3 + strlen($payment->stFormaPagamento) + strlen(number_format($payment->vrFormaPagamento, 2, ',', '.'))));
                $body = str_pad($body, strlen($body) + $aux, '.');
                $body .= 'R$ ' . number_format($payment->vrFormaPagamento, 2, ',', '.') . chr(10);

                if ($payment->idTipo == 12 || $payment->idTipo == 14) $flContaAssinada = true;
            }

            $payments = Payment::select(['cx_FormasPagamento.*', 'cx_FormasPagamento.stFormaPagamento', 'cx_FormasPagamento.idTipo'])
                ->join('cx_FormasPagamento', 'dlv_FichaPagamentos.idFormaPagamento', '=', 'cx_FormasPagamento.idFormaPagamento')
                ->where(["idAtendimento" => $id, "cx_FormasPagamento.flTroco" => true])
                ->get();

            foreach ($payments as $payment) {
                $body .= $dottedLine . chr(10);
                $body .= 'TROCO EM ' . $payment->stFormaPagamento;

                $aux = ($totalLines - (15 + strlen($payment->stFormaPagamento) + strlen(number_format($payment->vrFormaPagamento))));
                $body = str_pad($body, strlen($body) + $aux, '.');
                $body .= 'R$ ' . number_format($payment->vrFormaPagamento, 2, ',', '.') . chr(10);

                if ($payment->idTipo == 12 || $payment->idTipo == 14) $flContaAssinada = true;
            }

            //FIM DAS FORMAS DE PAGAMENTO
            $body .= $dottedLine . chr(10);
        }

        if ($flContaAssinada) {
            $order = Order::select(['dlv_Clientes.*'])
                ->join('dlv_Clientes', 'dlv_Clientes.idCliente', '=', 'dlv_Atendimentos.idCliente')
                ->where(["idAtendimento" => $id])
                ->get()
                ->first();

            $body .= chr(10);
            $body .= "EU, " . $order->stCliente . " CONCORDO COM OS TERMOS DISCRIMINADOS NESTE CUPOM." . chr(10) . chr(10) . chr(10);
            $body .= "________________________________________________" . chr(10);
            $body .= "ASSINATURA DO CLIENTE" . chr(10) . chr(10);
        }

        $aux = intval(($totalLines - strlen($stRodapeCupom)) / 2);
        $body = str_pad($body, strlen($body) + $aux);
        $body .= $stRodapeCupom . chr(10);

        $body .= $this->barCode($config->stMarcaPrint , $id);
        $body .= $this->footer($config->stMarcaPrint);

        $body .= "                                                " . chr(10) . chr(10) . chr(10);

        for ($x = 0; $x < $config->nrVias; $x++) {
            CouponPrint::create([
                'dtAlteracao' => Carbon::now(),
                'idImpressao' => CouponPrint::max('idImpressao') + 1,
                'stLocalPrint' => $config->stTipoPorta,
                'stOperadorLock' => $name,
                'idComanda' => "",
                'stCupom' => base64_encode($body),
            ]);
        }
    }

    function printRemoteCoupon($id, $name = 'Ifood', $budget = false, $itemsCancel = 0)
    {
        $integration = new Integration($name);

        $terminal = '';
        if(isset($integration->idDeliveryPadrao)){
            $terminal = $integration->idDeliveryPadrao;
        }
        if(!$terminal) return;

        $arrItems = "";
        $config = DlvConfig::find($terminal);

        $updateItems = false;
        $printers = Impressora::all();
        $totalLines = 48;
        $order = Order::find($id);
        $items = Item::select(['dlv_Itens.nrQuantidade',
            'prd_Produtos.stProduto',
            'dlv_Itens.vrTotal',
            'prd_Produtos.idProduto',
            'dlv_Itens.stOBS',
            'prd_Medidas.flFracionado',
            'prd_Medidas.stMedida',
            'dlv_Itens.stValores',
            'dlv_Itens.stCodigos',
            'dlv_Itens.stQuantidades',
            'dlv_Itens.flPrint',
            'dlv_Itens.nrItem'])
            ->join('prd_Produtos', 'dlv_Itens.idProduto', '=', 'prd_Produtos.idProduto')
            ->join('prd_Medidas', 'prd_Produtos.idMedida', '=', 'prd_Medidas.idMedida')
            ->where('dlv_Itens.idAtendimento', $id)
            ->where(function ($query) use ($budget, $itemsCancel) {
                if ($budget && $itemsCancel > 0) $query->where('dlv_Itens.nrItem', $itemsCancel);
            })
            ->orderBy('dlv_Itens.nrItem')
            ->get();
        $date = Carbon::now()->toTimeString();
        $cancel = "CANCELAMENTO";

        foreach ($printers as $printer) {
            $printNow = false;
            $COMPRESS = $this->compress($printer->stModelo);
            $EXPAND = $this->expand($printer->stModelo);

            $body = $printer->stModelo == "DARUMA" ? chr(27) . "@" : "";

            if ($order->flClienteRetira) $body .= $body .= $EXPAND . "   # CLIENTE RETIRA #" . $COMPRESS . chr(10);
            else $body .= $EXPAND . "      # DELIVERY #" . $COMPRESS . chr(10);

            $body .= "------------------------------------------------" . chr(10);
            $body .= "OPERADOR: " . $name;

            $aux = 22 - strlen($name);
            $body = str_pad($body, $aux + strlen($body));
            $body .= $date . chr(10);

            if ($order->nrPedido == 0) {
                $body .= $EXPAND . "PEDIDO: " . $COMPRESS;
                $body .= $EXPAND . $id . $COMPRESS . chr(10);
            } else {
                $body .= "PEDIDO  : ";
                $body .= $id . chr(10);
            }

            if ($order->nrPedido > 0) {
                $body .= $EXPAND . "CONTROLE: " . $COMPRESS;
                $body .= $EXPAND . $order->nrPedido . $COMPRESS . chr(10);
            }

            $body .= "ORIGEM  : ";
            $body .= "DELIVERY [" . $_SERVER['REMOTE_ADDR'] . "]" . chr(10);
            $body .= "------------------------------------------------" . chr(10);

            if ($budget) {
                $body .= $EXPAND;
                $aux = intval((24 - strlen($cancel)) / 2);
                $body = str_pad($body, $aux + strlen($aux));
                $body .= $cancel . $COMPRESS . chr(10) . "------------------------------------------------" . chr(10);
            }
            foreach ($items as $item) {
                if ($item->flPrint || $printer->flPrintAll || $budget) {
                    $aux = FichaTecnica::where([
                        'idProduto' => $item->idProduto,
                        'idPrint' => $printer->idPrint,
                        'idMicroterminal' => $config->idMicroterminal
                    ]);
                    $num = $aux->count();
                    if ($num > 0) {

                        if ($item->flFracionado) $nrQuantidade = number_format($item->nrQuantidade, 3, '.', "");
                        else $nrQuantidade = intval($item->nrQuantidade) . " " . $item->stMedida;

                        $body .= $EXPAND . $nrQuantidade . chr(10) . $COMPRESS;
                        if (strlen(trim($item->stCodigos)) > 0) {
                            $stCodigos = explode("@", $item->stCodigos);
                            $stQuantidades = explode("@", $item->stQuantidades);
                            $stValores = explode("@", $item->stValores);

                            $products = Product::whereIn('idProduto', $stCodigos)->get();
                            foreach ($products as $product) {
                                $body .= $EXPAND . substr($stQuantidades[0] . " " . $product->stProdutoAbreviado, 0, 24) . chr(10) . $COMPRESS;
                            }
                        } else {
                            $body .= $EXPAND . substr($item->stProduto, 0, 24) . chr(10) . $COMPRESS;
                        }

                        $body .= $item->stOBS . chr(10);
                        $body .= "------------------------------------------------" . chr(10);
                        $printNow = true;
                        $arrItems .= (!$arrItems ? $item->nrItem : ", " . $item->nrItem);
                    }
                }
            }
            if ($printNow) {
                $anotherSectors = "";
                $cnt = 0;
                $itemsDistinct = Item::select(['mt_ProdutosPrint.idPrint', 'mt_Prints.stPrint', 'mt_Prints.stLocalPrint'])
                    ->distinct()
                    ->join('mt_ProdutosPrint', 'dlv_Itens.idProduto', '=', 'mt_ProdutosPrint.idProduto')
                    ->join('mt_Prints', 'mt_ProdutosPrint.idPrint', '=', 'mt_Prints.idPrint')
                    ->where('dlv_Itens.idAtendimento', $id)
                    ->get();
                foreach ($itemsDistinct as $itemDistinct) {
                    $anotherSectors .= (strlen($anotherSectors) > 0 ? ", " : "");
                    $cnt += (strlen($anotherSectors) > 0 ? strlen($itemDistinct->stPrint) + 2 : strlen($itemDistinct->stPrint));
                    if ($cnt > $totalLines) {
                        $anotherSectors .= chr(10);
                        $cnt = 0;
                    }
                    $anotherSectors .= $itemDistinct->stPrint;
                }
                if (strlen($anotherSectors) > 0) {
                    $body .= "************************************************" . chr(10);
                    $body .= "ESTE PEDIDO POSSUI ITENS EM OUTROS SETORES:" . chr(10);
                    $body .= $anotherSectors . chr(10);
                    $body .= "************************************************" . chr(10);
                }

                $body .= $this->footer($printer->stModelo);
                $updateItems = true;

                if ($printer->stCanal == 'MG') {
                    Prints::create([
                        'idImpressao' => Prints::max('idImpressao') + 1,
                        'dtData' => Carbon::now()->toTimeString(),
                        'stImpressao' => base64_encode($body),
                        'idImpressora' => $printer->idPrint,
                        'idTerminal' => $_SERVER['REMOTE_ADDR'],
                        'flPrinted' => false
                    ]);

                } else {
                    CouponPrint::create([
                        'dtAlteracao' => Carbon::now(),
                        'idImpressao' => CouponPrint::max('idImpressao') + 1,
                        'stLocalPrint' => $printer->stLocalPrint,
                        'stOperadorLock' => $name,
                        'idComanda' => "",
                        'stCupom' => base64_encode($body),
                    ]);
                }
            }
        }

        if ($updateItems) {
            Item::where('idAtendimento', $id)->update(['flPrint' => false]);
        }
    }

    function printControlCoupon($idAtendimento, $name, $SEARCH_BY = 'CATEGORY') //TODO terminar
    {
        $config = PontoDelivery::find($_SERVER['REMOTE_ADDR']);

        if ($config->stMarcaPrint == "SEM IMPRESSORA") return;

        $TMP_FOLDER_PRINT = 'print';
        if (!is_dir($TMP_FOLDER_PRINT)) @mkdir($TMP_FOLDER_PRINT);

        $EXPAND = $this->expand($config->stMarcaPrint);
        $COMPRESS = $this->compress($config->stMarcaPrint);

        $order = Order::find($idAtendimento);
        $header = "";

        if ($config->stMarcaPrint == "DARUMA") $header = chr(27) . "@";
        $header .= "================================================" . chr(10);
        $header .= "PEDIDO: ";
        $header .= $idAtendimento;

        for ($x = 0; $x < (21 - strlen($idAtendimento)); $x++) {
            $header .= " ";
        }

        $header .= Carbon::createFromFormat("d-m-Y H:i:s", $order->dtAbertura) . chr(10);

        if (intval($order->nrPedido) > 0) {
            $header .= $EXPAND . "CONTROLE: " . $COMPRESS;
            $header .= $EXPAND . $order->nrPedido . $COMPRESS . chr(10);
        }

        $costumer = Customer::find($order->idCliente);
        $header .= "CLIENTE: ";
        $header .= substr($costumer->stCliente, 0, 39) . chr(10);

        $cep = CEP::where('stCEP', $costumer->idCEP);

        $header .= "RUA: ";
        $header .= substr($cep->stEndereco, 0, 43) . chr(10);
        $header .= "NUMERO: ";
        $header .= $costumer->nrNumero . chr(10);
        $header .= "BAIRRO: ";
        $header .= substr($cep->stBairro, 0, 40) . chr(10);

        if (strlen(trim($costumer->stComplemento)) > 0) {
            $header .= "COMPLEMENTO: ";
            $header .= $costumer->stComplemento . chr(10);
        }
        if ($order->flAgendarPedido) {
            $header .= "================================================" . chr(10);

            if ($order->dtAgendarPedido != $order->dtAgendarPedidoProducao) {
                $header .= "PRODUZIR PARA:  ";
                $header .= $EXPAND . Carbon::createFromFormat("d-m-Y H:i", $order->dtAgendarPedidoProducao) . $COMPRESS . chr(10);
            } else {
                $header .= $EXPAND ."AGENDADO PARA: " . $COMPRESS;
                $header .= $EXPAND . Carbon::createFromFormat("d-m-Y H:i", $order->dtAgendarPedido) . $COMPRESS . chr(10);
            }
        }

        $header .= "================================================" . chr(10);

        $items = null;
        $vrTotal = 0;
        $body = "";
        $old = "";

        //Lista de Produtos
        if ($SEARCH_BY == 'CATEGORY') {
            $items = Item::select(DB::raw('MIN(prd_Codigos.idCodigo) AS idCodigo,
            dlv_Itens.nrQuantidade,
            prd_Produtos.stProdutoAbreviado,
            dlv_Itens.vrTotal,
            dlv_Itens.vrUnitario,
            prd_Produtos.idProduto,
            dlv_Itens.stOBS,
            prd_Medidas.flFracionado,
            prd_Medidas.stMedida,
            dlv_Itens.stValores,
            dlv_Itens.stCodigos,
            dlv_Itens.stQuantidades,
            prd_Categorias.stCategoria'))
                ->join('prd_Produtos', 'dlv_Itens.idProduto', '=', 'prd_Produtos.idProduto')
                ->join('prd_Categorias', 'prd_Produtos.idCategoria', '=', 'prd_Categorias.idCategoria')
                ->join('prd_Codigos', 'prd_Produtos.idProduto', '=', 'prd_Codigos.idProduto')
                ->join('prd_Medidas', 'prd_Produtos.idMedida', '=', 'prd_Medidas.idMedida')
                ->where('dlv_Itens.idAtendimento', '=', $idAtendimento)
                ->where('prd_Codigos.idCodigo', '<>', '-100')
                ->groupBy('prd_Categorias.stCategoria',
                    'dlv_Itens.nrQuantidade',
                    'prd_Produtos.stProdutoAbreviado',
                    'dlv_Itens.vrTotal',
                    'dlv_Itens.vrUnitario',
                    'prd_Produtos.idProduto',
                    'dlv_Itens.stOBS',
                    'prd_Medidas.flFracionado',
                    'prd_Medidas.stMedida',
                    'dlv_Itens.stValores',
                    'dlv_Itens.stCodigos',
                    'dlv_Itens.stQuantidades',
                    'dlv_Itens.nrItem')
                ->orderBy('prd_Categorias.stCategoria', 'dlv_Itens.nrItem')
                ->get();
        } else if ($SEARCH_BY == 'SECTOR') {
            $items = Item::select(DB::raw('MIN(prd_Codigos.idCodigo) AS idCodigo,
            dlv_Itens.nrQuantidade,
            prd_Produtos.stProdutoAbreviado,
            dlv_Itens.vrTotal,
            dlv_Itens.vrUnitario,
            prd_Produtos.idProduto,
            dlv_Itens.stOBS,
            prd_Medidas.flFracionado,
            prd_Medidas.stMedida,
            dlv_Itens.stValores,
            dlv_Itens.stCodigos,
            dlv_Itens.stQuantidades,
            prd_Categorias.stCategoria'))
                ->join('prd_Produtos', 'dlv_Itens.idProduto', '=', 'prd_Produtos.idProduto')
                ->join('prd_Setores', 'prd_Produtos.idSetor', '=', 'prd_Setores.idSetor')
                ->join('prd_Codigos', 'prd_Produtos.idProduto', '=', 'prd_Codigos.idProduto')
                ->join('prd_Medidas', 'prd_Produtos.idMedida', '=', 'prd_Medidas.idMedida')
                ->where('dlv_Itens.idAtendimento', '=', $idAtendimento)
                ->where('prd_Codigos.idCodigo', '<>', '-100')
                ->groupBy('prd_Setores.idSetor',
                    'dlv_Itens.nrQuantidade',
                    'prd_Produtos.stProdutoAbreviado',
                    'dlv_Itens.vrTotal',
                    'dlv_Itens.vrUnitario',
                    'prd_Produtos.idProduto',
                    'dlv_Itens.stOBS',
                    'prd_Medidas.flFracionado',
                    'prd_Medidas.stMedida',
                    'dlv_Itens.stValores',
                    'dlv_Itens.stCodigos',
                    'dlv_Itens.stQuantidades',
                    'dlv_Itens.nrItem')
                ->orderBy('prd_Setores.idSetor', 'dlv_Itens.nrItem')
                ->get();
            foreach ($items as $item) {
                if ($item->stSetor != $old) {
                    $old = $item->stSetor;
                    if (strlen($body) > 0) {
                        $body .= $this->barCode($config->stMarcaPrint, $idAtendimento);
                        $body .= $this->footer($config->stMarcaPrint);

                        // INTO mt_Impressoes (idImpressao, dtData, stImpressao, idImpressora, idTerminal, flPrinted)
                        // VALUES ('$idImpressao', '" . date("Y-m-d H:i:s") . "', '$body', '0', '" . $_SERVER['REMOTE_ADDR'] . "', 'false')"
                        if ($config->flPrintManager) {
                            Prints::create([
                                'idImpressao' => Prints::max('idImpressao') + 1,
                                'dtData' => Carbon::now(),
                                'stImpressao' => base64_encode($body),
                                'idImpressora' => '0',
                                'idTerminal' => $_SERVER['REMOTE_ADDR'],
                                'flPrinted' => false,
                            ]);
                        } else {
                            CouponPrint::create([
                                'dtAlteracao' => Carbon::now(),
                                'idImpressao' => CouponPrint::max('idImpressao') + 1,
                                'stLocalPrint' => $config->stTipoPorta,
                                'stOperadorLock' => $name,
                                'idComanda' => "",
                                'stCupom' => base64_encode($body),
                            ]);
                            $printFile = @fopen("$TMP_FOLDER_PRINT\\" . $idAtendimento . "_preparo.txt", "w");
                            @fwrite($printFile, $body) or die("Falha escrever em arquivo!");
                            @fclose($printFile) or die("Falha ao fechar arquivo!");
                            @copy("$TMP_FOLDER_PRINT\\" . $idAtendimento . "_preparo.txt", $config->stTipoPorta);
                            @unlink("$TMP_FOLDER_PRINT\\" . $idAtendimento . "_preparo.txt");
                        }
                    }
                    $body = "";
                    $body .= $EXPAND . "   * ORDEM PRODUCAO *   " . $COMPRESS . chr(10);
                    $body .= "------------------------------------------------" . chr(10);

                    $body .= $EXPAND . $costumer->flClienteRetira ? "   # CLIENTE RETIRA #" : "      # DELIVERY #" . $COMPRESS . chr(10);

                    $body .= "================================================" . chr(10);

                    for ($x = 0; $x < intval(16 - strlen($item->stCategoria)); $x++) {
                        $body .= " ";
                    }
                    $body .= $EXPAND . "--- " . substr($item->stCategoria, 0, 16) . " ---" . $COMPRESS . chr(10);
                    $body .= $header;

                    if ($item->flFracionado) $body .= $EXPAND . number_format($item->nrQuantidade, 3, ".", "") . " " . $item->stMedida . $COMPRESS . chr(10);
                    else $body .= $EXPAND . $item->nrQuantidade . " " . $item->stMedida . $COMPRESS . chr(10);

                    if (strlen(trim($item->stCodigos))) {

                    }
                }
            }
        }

//                FichaTecnica::
    }

    private function compress($print)
    {
        $res = null;
        switch ($print) {
            case "BEMATECH":
            case "BEMATECH_MP2100TH":
                $res = chr(27) . "W0";
                break;
            case "TANCA":
            case "EPSON_T20":
            case "EPSON_T88III":
            case "EPSON":
                $res = chr(27) . "!" . chr(1) . chr(27) . " " . chr(0);
                break;
            case "DARUMA":
            case "DARUMA_THERMICA":
                $res = chr(27) . "M";
                break;
            default:
                $res = "";
                break;
        }
        return $res;
    }

    private function expand($print)
    {
        $res = null;
        switch ($print) {
            case "BEMATECH":
            case "BEMATECH_MP2100TH":
            case "BEMATECH_MP20MI_TH":
                $res = chr(27) . "W1";
                break;
            case "EPSON_T20":
            case "TANCA":
            case "EPSON":
            case "EPSON_T88III":
                $res = chr(27) . " " . chr(6) . chr(27) . "!" . chr(8);
                break;
            case "DIEBLO_IM423T":
                $res = chr(27) . "W" . chr(1);
                break;
            case "DARUMA_THERMICA":
                $res = chr(27) . chr(14);
                break;
            default:
                $res = "";
                break;
        }
        return $res;
    }

    private function barCode($print, $idAtendimento)
    {
        $res = null;
        switch ($print) {
            case "EPSON":
            case "TANCA":
            case "EPSON_T20":
            case "EPSON_T88III":
            case "BEMATECH":
            case "BEMATECH_MP2100TH":
            case "BEMATECH_MP20MI_TH":
                $res = chr(10) . chr(29) . "H" . chr(2) . chr(29) . "w" . chr(2) . chr(29) . "h" . chr(100) . chr(29) . "k" . chr(69) . chr(13) . "D" . str_pad($idAtendimento, 12, "0", STR_PAD_LEFT) . chr(0);
                break;
            case "DARUMA":
            case "DARUMA_THERMICA":
                $res = chr(10) . chr(27) . "b" . chr(5) . chr(3) . chr(100) . chr(1) . "D" . str_pad($idAtendimento, 12, "0", STR_PAD_LEFT) . chr(0);
                break;
            default:
                $res = "";
                break;
        }
        return $res;
    }

    private function footer($print)
    {
        $res = null;
        switch ($print) {
            case "BEMATECH":
                $res = chr(27) . "w";
                break;
            case "EPSON_T20":
            case "EPSON_T88III":
            case "TANCA":
            case "EPSON":
                $res = chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(27) . "i";
                break;
            case "DARUMA":
                $res = chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(7) . chr(27) . "m";
                break;
            default:
                $res = chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10) . chr(10);
                break;
        }
        return $res;
    }
}
