<?php

namespace App\Services\Nati;

use App\Entities\Nati\Localizacao;
use App\Repositories\Nati\LocalizacaoRepository;
use App\Validators\Nati\LocalizacaoValidator;
use Illuminate\Support\Str;
use Prettus\Validator\Contracts\ValidatorInterface;
use Carbon\Carbon;
use App\Entities\Nati\Product;

class LocalizacaoService
{
    private $repository;
    private $validator;


    public function __construct(LocalizacaoRepository $repository, LocalizacaoValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getById($id) {

        return $this->repository->withCount('produtos')->find($id);
    }

    public function all()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        return $this->repository->withCount('produtos')->findWhere(['flAtivo' => true]);

    }

    public function create($request)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $localizacao = [
            'idLocalizacao'        => Localizacao::max('idLocalizacao') + 1,
            'stLocalizacao'        => Str::upper($request['stLocalizacao']),
            'flAtivo'              => true,
            'dtAlteracao'          => Carbon::now(),

        ];


        return $this->repository->create($localizacao);
    }

    public function update($request, $id)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        $request['stLocalizacao'] = Str::upper($request['stLocalizacao']);

        return $this->repository->update($request, $id);

    }
    public function delete($id)
    {
        //if()

        return $this->repository->update(['flAtivo' => false], $id);

    }

    private function getNextId()
    {
        return $aliquota = Localizacao::max('idLocalizacao') + 1;
    }
}
