<?php


namespace App\Services;

use App\Entities\SaleTemp;
use Carbon\Carbon;
use App\Entities\Nati\PosConfig;
use App\Validators\SaleTempValidator;
use App\Services\Nati\ProductService;
use App\Repositories\SaleTempRepository;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;

class SaleTempService
{
    protected $repository;
    protected $validator;
    protected $gerenciadorService;
    protected $productService;

    public function __construct(SaleTempRepository $repository, SaleTempValidator $validator, ManagerService $gerenciadorService, ProductService $productService)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->gerenciadorService = $gerenciadorService;
        $this->productService = $productService;
    }
    public function store($data){
        $x = $data;
    }

    public function insertVenda(array $request)
    {
        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return DB::transaction(function () use ($request){

            $posConfig = PosConfig::with(['user'])->where('flDesenfila', true)->first();

            $request['idCaixa'] = $posConfig['posId'];
            $request['idVenda'] = $this->nextId();
            $request['idAbertura'] = $this->gerenciadorService->getByPos($posConfig)->idAbertura;
            $request['dtData'] = Carbon::now();
            $request['dtAlteracao'] = Carbon::now();
            $request['flAtivo'] = true;
            $request['idCliente'] = 0;
            $request['nrTempoAtendimento'] = 0;
            $request['stFraseCupom'] = 'OBRIGADO VOLTE SEMPRE';
            $request['stContaAssinada'] = ' ';
            $request['flDelivery'] = false;
            $request['idAtendimentoDelivery'] = 0;
            $request['idOperadorAutorizador'] = $posConfig['userId'];

            if (isset($request['xmlKey'])) {
                $request['flNotaFiscal'] = true;
                $request['chave_fiscal'] = $request['xmlKey'];
            }else{
                $request['flNotaFiscal'] = false;
            }
            if (!isset($request['nrCOO'])) {
                $request['nrCOO'] = 0;
            }
            if (isset($request['customer'])) {
                $customer = $request['customer'];
                $request['stCPF'] = $customer['doc'];
            }

            $sale = $this->repository->create($request);

            $cont = 1;
            foreach ($request['items'] as $it) {
                $prod = $this->productService->getByCode($it['code']);
                $item = new ItemTemp();
                $item->idItem = $cont;
                $item->dtData = Carbon::now();
                $item->dtAlteracao = Carbon::now();
                $item->idVenda = $sale->idVenda;
                $item->idAbertura = $sale->idAbertura;
                $item->idProduto = $prod['idProduto'];
                $item->vrCusto = $prod['vrCusto'];
                $item->vrUnitario = $it['unitPrice'];

                $item->vrDesconto = 0;
                $item->flAtivo = true;
                $item->idComanda = $request['tabId'];
                $item->idCodProduto = $it['code'];
                $item->vrTotal = $it['netAmount'];

                if($prod->medida->flFracionado){
                    $item->nrQuantidade = $it['quantity'] * 1000;
                    $item->vrTotalCusto =  $item->vrCusto * $item->nrQuantidade;
                }else{
                    $item->nrQuantidade = $it['quantity'];
                    $item->vrTotalCusto =  $item->vrCusto * $item->nrQuantidade;
                }

                $item->idOperadorAutorizador = $posConfig['userId'];
                $item->stAtendente = $posConfig->user->stApelido;
                $item->flEstoqueBaixado = false;
                $item->flPromocao = false;

                $sale->itens_temp()->save($item);
                $cont = $cont + 1;
            }
            $cont = 1;
            foreach ($request['payments'] as $pay) {
                $payment = new FichaRecebimentoTemp();
                $payment->idFicha = $cont;
                $payment->idVenda = $sale->idVenda;
                $payment->idAbertura = $sale->idAbertura;

                $payment->idFormaPagamento = $posConfig->paymentId;
                $payment->vrFormaPagamento = $pay['valor'];

                $payment->dtdata = Carbon::now();
                $payment->flTroco = false;
                $payment->flAtivo = true;
                $payment->dtAlteracao = Carbon::now();
                $sale->fichaRecebimento()->save($payment);
            }

            return $sale;
        });
    }

    public function nextId()
    {
        return SaleTemp::max('idVenda') + 1;
    }
}
