<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCadCestTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {

        if (!Schema::hasTable('cad_Cest')) {
            Schema::disableForeignKeyConstraints();
            Schema::create('cad_cest', function(Blueprint $table) {
                $table->string('nrNCM', 8);
                $table->string('nrCest', 7);
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary('nrNcm');
            });
            Schema::enableForeignKeyConstraints();
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cad_Cest');
    }
}

