<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxVendasTempTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Vendas_Temp')) {
            Schema::create('cx_Vendas_Temp', function (Blueprint $table) {
                $table->integer('idVenda', false, true);
                $table->integer('idAbertura', false, true);
                $table->decimal('vrTotal', 9, 2);
                $table->boolean('flNotaFiscal')->default(false);
                $table->dateTime('dtData')->default(Carbon::now());
                $table->integer('idCliente');
                $table->decimal('vrDesconto', 9, 2);
                $table->decimal('vrAcrescimo', 9, 2);
                $table->boolean('flAtivo')->default(true);
                $table->decimal('nrTempoAtendimento', 13, 0);
                $table->integer('idOperadorAutorizador');
                $table->string('stFraseCupom')->nullable(true);
                $table->boolean('flDelivery');
                $table->integer('idAtendimentoDelivery');
                $table->string('stContaAssinada');
                $table->dateTime('dtAlteracao');
                $table->bigInteger('nrCOO', false, true)->nullable(true);
                $table->string('stCPF', 16);
                $table->string('uuid');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Vendas_Temp');
    }
}
