<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvAtendimentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Atendimentos')) {
            Schema::create('dlv_Atendimentos', function (Blueprint $table) {
                $table->bigInteger('idAtendimento', false, true);
                $table->bigInteger('idCliente', false, true);
                $table->bigInteger('idOperador', false, true);
                $table->dateTime('dtAbertura');
                $table->dateTime('dtConclusao');
                $table->text('stOBS')->nullable();
                $table->string('stStatus', 1)->default('F');
                $table->boolean('flAtivo')->default(true);
                $table->boolean('flAgendarPedido')->default(false);
                $table->dateTime('dtAgendarPedido')->nullable();
                $table->boolean('flCupomImpresso')->default(false);
                $table->bigInteger('idAbertura', false, true)->nullable();
                $table->bigInteger('idVenda', false, true)->nullable();
                $table->dateTime('dtSaidaMotoboy')->nullable();
                $table->dateTime('dtChegadaMotoboy')->nullable();
                $table->bigInteger('idMotoboy', false, true)->nullable();
                $table->boolean('flOrcamento')->default(false);
                $table->boolean('flPago')->default(false);
                $table->boolean('flNF')->default(false);
                $table->dateTime('dtAgendarPedidoProducao')->nullable();
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->bigInteger('nrPedido', false, true)->nullable();
                $table->boolean('flRetornouComanda')->default(false);
                $table->boolean('flClienteRetira')->default(false);

                $table->primary('idAtendimento');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Atendimentos');
    }
}
