<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Config')) {
                Schema::create('dlv_Config', function(Blueprint $table) {
                    $table->string('idDelivery', 15);
                    $table->string('stMarcaPrint', 50)->default('GENERICA');
                    $table->string('stTipoPorta', 50)->default('PARALELA');
                    $table->integer('nrDddPadrao', false, true)->default('11');
                    $table->string('stRodapeCupom', 48)->default('OBRIGADO PELA PREFERENCIA');
                    $table->string('stCabecalhoCupom1', 48)->default('ARCNET AUTOMACAO COMERCIAL');
                    $table->string('stCabecalhoCupom2', 48)->default('RUA MELO PEIXOTO 1163 -TAUTAPE');
                    $table->string('stCabecalhoCupom3', 48)->default('(11) 3337-3475');
                    $table->string('stCabecalhoCupom4', 48)->default('WWW.ARCNET.COM.BR');
                    $table->string('stCidade', 50)->default('SAO PAULO');
                    $table->string('stEstado', 2)->default('SP');
                    $table->integer('nrVias', false, true);
                    $table->string('idMicroterminal', 15);
                    $table->boolean('flTaxaEntregaUnica')->default(false);
                    $table->decimal('vrTaxaEntregaUnica', 9, 2)->default(0);
                    $table->integer('nrAlertaEntrega', false, true)->default(2);
                    $table->boolean('flSolicitarOperador');
                    $table->boolean('flAtivo');
                    $table->dateTime('dtAlteracao')->default(Carbon::now());
                    $table->boolean('flPrintCupomPreparo')->default(false);
                    $table->boolean('flPrintManager')->default(false);
                    $table->boolean('flAssumirPedido')->default(false);
                    $table->boolean('flHorarios')->default(true);

                    $table->primary('idDelivery');
                });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Config');
    }
}
