<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateDlvTelefonesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('dlv_Telefones')) {
            Schema::create('dlv_Telefones', function (Blueprint $table) {
                $table->integer('idCliente', false, true);
                $table->string('nrTelefone', 50)->unique();
                $table->smallInteger('nrRamal')->default(0);
                $table->smallInteger('idTipoTelefone');
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());

                $table->primary(['idCliente', 'nrTelefone']);
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('dlv_Telefones');

    }
}
