<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtProdutosPrintsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_ProdutosPrint')) {
            Schema::create('mt_ProdutosPrint', function (Blueprint $table) {
                $table->unsignedInteger('idPrint');
                $table->unsignedInteger('idProduto');
                $table->string('idMicroterminal', 15);
                $table->unsignedSmallInteger('idSetor');
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->foreign('idPrint')->references('idPrint')->on('mt_Prints');
                $table->foreign('idProduto')->references('idProduto')->on('prd_Produtos');
                $table->foreign('idMicroterminal')->references('idMicroterminal')->on('mt_Microterminais');
                $table->foreign('idSetor')->references('idSetor')->on('prd_Setores');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_ProdutosPrint');
    }
}
