<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNatLogTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('nat_Log')) {
            Schema::create('nat_Log', function (Blueprint $table) {
                $table->bigInteger('idLog');
                $table->string('stOperador', 20);
                $table->dateTime('dtData');
                $table->string('stArea', 20);
                $table->string('stDescricao', 255);
                $table->string('stSoftware', 20);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nat_Log');
    }
}
