<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterMaster extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(Schema::hasTable('master')){
            if(!Schema::hasColumn('master', 'flBloquearComandasInativas')){
                Schema::table('master', function (Blueprint $table){
                    $table->boolean('flBloquearComandasInativas')->default(0);
                });
            }
            if(!Schema::hasColumn('master', 'flBloquearPedidosDeliveryInativos')){
                Schema::table('master', function (Blueprint $table){
                    $table->boolean('flBloquearPedidosDeliveryInativos')->default(0);
                });
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasTable('master')){
            if(Schema::hasColumn('master', 'flBloquearComandasInativas')){
                Schema::table('master', function (Blueprint $table){
                    $table->dropColumn('flBloquearComandasInativas');
                });
            }
            if(Schema::hasColumn('master', 'flBloquearPedidosDeliveryInativos')){
                Schema::table('master', function (Blueprint $table){
                    $table->dropColumn('flBloquearPedidosDeliveryInativos');
                });
            }
        }
    }
}
