<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterTriggerTrComandas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if($this->triggerExists()) {
            DB::statement("
                ALTER TRIGGER [dbo].[TR_COMANDAS]
                ON [dbo].[mt_Atendimentos]
                AFTER INSERT, DELETE
                AS
                BEGIN
                SET NOCOUNT ON;
                declare @idComanda int
                declare @stStatus nvarchar(1)
                DECLARE @MyCursor CURSOR;

                IF EXISTS (SELECT * FROM inserted) AND NOT EXISTS (SELECT * FROM deleted)
                BEGIN
                    set @MyCursor = cursor for SELECT idComanda FROM inserted
                    open @MyCursor
                    fetch NEXT from @MyCursor into @idComanda

                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                        if not exists(select idComanda from cmd_Comandas where idComanda = @idComanda)
                            BEGIN
                                SET NOCOUNT ON
                                INSERT INTO cmd_Comandas (idComanda, stStatus) VALUES(@idComanda,'C')
                            END
                        ELSE
                            BEGIN
                                UPDATE cmd_Comandas set stStatus = 'C' where idComanda = @idComanda
                            END
                        FETCH NEXT FROM @MyCursor INTO @idComanda
                    END

                    CLOSE @MyCursor ;
                    DEALLOCATE @MyCursor;
                END

                IF EXISTS (SELECT * FROM deleted) AND NOT EXISTS (SELECT * FROM inserted)
                BEGIN
                    set @MyCursor = cursor for SELECT idComanda FROM deleted
                    open @MyCursor
                    fetch NEXT from @MyCursor into @idComanda

                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                        if not exists(select idComanda from cmd_Comandas where idComanda = @idComanda)
                            BEGIN
                                SET NOCOUNT ON
                                INSERT INTO cmd_Comandas (idComanda, stStatus) VALUES(@idComanda,'L')
                            END
                        ELSE
                            BEGIN
                            SET NOCOUNT ON
                                UPDATE cmd_Comandas set stStatus = 'L' where idComanda = @idComanda
                            END

                        FETCH NEXT FROM @MyCursor INTO @idComanda
                    END

                    CLOSE @MyCursor ;
                    DEALLOCATE @MyCursor;
                END
                END
            ");
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    private function triggerExists()
    {
        $res = DB::select("
            if exists (select 1 from sys.triggers where name = 'TR_COMANDAS')
            begin
                select isTrue = 1
            end
            else
                select isTrue = 0
        ");

        if($res[0]->isTrue == "1") {
            return true;
        } else {
            return false;
        }
    }
}
