<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompany extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('company')) {
            Schema::create('company', function (Blueprint $table) {
                $table->integer('id', false, true);
                $table->string('email', 50)->nullable();
                $table->string('nome', 50);
                $table->string('cnpj', 14);
                $table->string('cep', 8)->nullable();
                $table->string('rua', 60)->nullable();
                $table->string('numero', 60)->nullable();
                $table->string('complemento', 60)->nullable();
                $table->string('bairro', 60)->nullable();
                $table->string('cidade', 60)->nullable();
                $table->string('estado', 60)->nullable();
                $table->string('telefone', 14)->nullable();
                $table->string('prefixo', 3)->nullable();
                $table->string('paymentProvider', 50)->nullable();
                $table->string('paymentProviderClientId', 100);
                $table->string('paymentProviderSubscriptionId', 100)->nullable();
                $table->boolean('suspended')->default(0);
                $table->boolean('active')->default(1);
                $table->timestamps();

                $table->primary('id');

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasTable('company')) {
            Schema::dropIfExists('company');
        }
    }
}
