<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFrnFichaFornecedorTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('frn_FichaFornecedor')) {

            DB::statement('CREATE TABLE [dbo].[frn_FichaFornecedor](
                  [idFornecedor] [int] NOT NULL,
                  [idProduto] [int] NOT NULL,
                  [idCategoria] [smallint] NOT NULL,
                  [codProdutoF] [varchar] NULL,
                  [stDescProdF] [varchar] NULL,
                  [dtLastSale] [smalldatetime] NULL,
                  [dtFirstSale] [smalldatetime] NULL,
                  [vrFirstSale] [decimal](9, 2) NULL,
                  [vrLastSale] [decimal](9, 2) NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_frn_FichaFornecedor_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_frn_FichaFornecedor] PRIMARY KEY CLUSTERED
                    (
                      [idFornecedor] ASC,
                      [idProduto] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('frn_FichaFornecedor');

    }
}
