<?php

/**
 * Description of VwPedidos
 *
 * @author Duardaum
 */
class VwPedidos extends Conexao {
    private $_name = "vw_pedidos";
    private $_sql;
    private $_version = "1.0";
    private $_file_log;
    
    public function __construct() {
        $this->_sql = "IF OBJECT_ID('".$this->_name."') IS NULL SELECT 0 as have ELSE SELECT 1 as have";
        $obj = mssql_fetch_object(parent::executar($this->_sql));
        $this->_sql = "SELECT a.*,
                                        CASE 
                                                WHEN a.stStatus = 'E' THEN 'ENTREGUE'
                                                WHEN a.stStatus = 'S' THEN 'SAIU PARA ENTREGA'
                                                WHEN a.stStatus = 'F' AND a.flAgendarPedido = '1' AND a.dtAgendarPedido > DATEADD(hour, 2, GETDATE()) THEN 'AGENDADO'
                                                WHEN a.stStatus = 'F' THEN 'FORMULACAO'
                                                WHEN a.stStatus = 'P' AND a.flAgendarPedido = '1' AND a.dtAgendarPedido > DATEADD(hour, 2, GETDATE()) THEN 'AGENDADO'
                                                WHEN a.stStatus = 'P' THEN 'PENDENTE'
                                        END as status,
                                   c.stCliente, c.nrNumero,
                                   cp.stEndereco, cp.stBairro, cp.stCidade, cp.stCEP,
                                   m.stMotoBoy,
                                   (SELECT TOP(1) MIN(nrTelefone) FROM dlv_Telefones WHERE idCliente = c.idCliente) as nrTelefone
                        FROM dlv_Atendimentos a
                        INNER JOIN dlv_Clientes c
                        ON a.idCliente = c.idCliente
                        INNER JOIN dlv_CEPs cp
                        ON c.idCEP = cp.idCEP
                        LEFT JOIN dlv_Motoboy m
                        ON a.idMotoboy = m.idMotoboy";
        
        switch($obj->have){
            case '0':{//no tem
                parent::executar($this->_sql);
                self::criaArquivoLog();
            break;
            }
            case '1':{//tem
                self::atualizaBancoDados();
            break;
            }
        }
    }
    
    private function atualizaBancoDados(){
        try{
            $root = str_replace("/database/models/VwPedidos.class.php", "", str_replace("\\", "/", __FILE__));
            $this->_file_log = $root."/log/".$this->_name."-".$this->_version.".txt";
            if(file_exists($this->_file_log))
                return true;
            
            parent::executar("DROP VIEW ".$this->_name);
            parent::executar($this->_sql);
            
            self::criaArquivoLog();
        }catch(Exception $ex){
            throw (new Exception("Erro ao tentar atualizar banco: ". $ex->getMessage()));
        }
    }
    
    private function criaArquivoLog(){
        $f = fopen($this->_file_log, "w+");
        fwrite($f, date("d/m/Y H:i:s"));
        fclose($f);
    }
    
    public function getWith($data_inicio, $data_fim, array $STATUS){
        $this->_sql = "SELECT * FROM ".$this->_name." WHERE ";
        
        if(in_array("X", $STATUS)) ://excluidos
            $this->_sql .= " flAtivo = '1' AND ";
            $key = array_keys($STATUS, "X");
            unset($STATUS[$key[0]]);
        endif;
        
        if(in_array("Y", $STATUS)) ://pagos
            $this->_sql .= "  flPago = '1' AND ";
            $key = array_keys($STATUS, "Y");
            unset($STATUS[$key[0]]);
        endif;
        
        if(in_array("A", $STATUS)) : //pedidos agendados
            $this->_sql .= " flAgendarPedido = '1' AND ";
            $key = array_keys($STATUS, "A");
            unset($STATUS[$key[0]]);
        endif;
        
        $this->_sql .= " stStatus IN(";
        foreach($STATUS as $status){//status: pendente, entregue, saiu para entrega e etc..
            $this->_sql .= "'".$status."', ";
        }
        $this->_sql .= ") AND ";
        
        if(!empty($data_inicio) || !empty($data_fim)) :
            $this->_sql .= " dtAbertura BETWEEN ('".date("Y-m-d", strtotime($data_inicio))." 00:00:00' AND '".date("Y-m-d", strtotime($data_fim))." 23:59:59')  AND ";
        endif;
        
        $this->_sql .= " flOrcamento = '0'
                         ORDER BY idAtendimento DESC;
                       ";
        
        return parent::executar($this->_sql);
    }
}