
<?
require_once "../functions.php";

db_conn();

if (autorization(7) == false)
{
	?>
	<SCRIPT>
		document.location = "../?sec=erro&sub=2";
	</SCRIPT>
	<?
	die;
}

$idAbertura = htmlspecialchars($_GET['id'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Detalhes de Cancelamentos</title>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/datatables.min.css" rel="stylesheet" type="text/css"/>
	<link href="resources/css/toastr.css" rel="stylesheet"/>
	<link href="resources/css/sweetalert2.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
		<caption class="table-caption"><b>Detalhes de Cancelamentos</b></caption>
		<thead>
			<tr>
				<td class="tdStyle" width="12%"><b>Operador</b></td>
				<td class="tdStyle" width="38%"><b>Produto</b></td>
				<td class="tdStyle" width="18%"><b>Data</b></td>
				<td class="tdStyle" width="16%"><b>Quantidade</b></td>
				<td class="tdStyle" width="15%"><b>Valor</b></td>
			</tr>
		</thead>
		<?
		if (is_numeric($idAbertura))
		{
			$sql = "SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido ".
			"FROM cx_Itens_Temp I ".
			"INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto ".
			"INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida ".
			"LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador ".
			"WHERE I.flAtivo = '0' AND I.idAbertura = '$idAbertura' ".
			"ORDER BY I.dtData DESC";
		}
		else
		{
			$sql = "SELECT I.dtData, P.stProduto, I.nrQuantidade, M.stMedida, M.flFracionado, I.vrTotal, O.stApelido ".
			"FROM cx_Itens_Temp I ".
			"INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto ".
			"INNER JOIN prd_Medidas M ON P.idMedida = M.idMedida ".
			"INNER JOIN cx_Gerenciador G ON I.idAbertura = G.idAbertura ".
			"LEFT JOIN op_Operadores O ON I.idOperadorAutorizador = O.idOperador ".
			"WHERE I.flAtivo = '0' AND G.flAberto = '1' ".
			"ORDER BY I.dtData DESC";
		}

		$res = mssql_query($sql);

		while ($arr = mssql_fetch_array($res))
		{
			$dtData = strtotime($arr['dtData']);
			$dtData = date("d/m/y H:i", $dtData);

			?>
			<tr>
				<td class="tdStyle"><?php echo $arr['stApelido']?></td>
				<td class="tdStyle"><?php echo $arr['stProduto']?></td>
				<td class="tdStyle"><?php echo $dtData?></td>
				<td class="tdStyle"><?php echo  ($arr['flFracionado'] ? number_format(($arr['nrQuantidade'] / 1000), 3, ".", "") : intval($arr['nrQuantidade'])) ?> <?php echo $arr['stMedida']?></td>
				<td class="tdStyle" align="right">R$ <?php echo $arr['vrTotal']?></td>
			</tr>
			<?
		}
		?>
	</table>
</body>
</html>
