<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'getCategorias':
            getCategorias();
            break;
        case 'cadastrarCategoria' :
            cadastrarCategoria($_POST['stCategoria']);
            break;
        case 'editarCategoria' :
            editarCategoria($_POST['idCategoria'], $_POST['stCategoria']);
            break;
        case 'deleteCategoria':
            deleteCategoria($_POST['idCategoria']);
            break;
        case 'getSubCategorias':
            getSubCategorias($_POST['categoria']);
            break;
        case 'cadastrarSubCategoria':
            cadastrarSubCategoria($_POST['subCategoria'], $_POST['Categoria'], $_POST['idSub']);
            break;
        case 'editarSubCategoria':
            editarSubCategoria($_POST['idCategoria'], $_POST['idSubCategoria']);
            break;
        case 'transferSub':
            transferSub($_POST['idCategoria'], $_POST['idSubCategoria'], $_POST['idCategoriaOld'], $_POST['idSubCategoriaOld']);
            break;
        case 'getProdutosByCategoria':
            getProdutosByCategoria($_POST['idCategoria']);
            break;
        case 'updatePrecos':
            updatePrecos($_POST['itens']);
            break;
        case 'getCategoriasItens':
            getCategoriasItens();
            break;
        case 'cadastrarCategoriaItem':
            cadastrarCategoriaItem($_POST['stCategoriaItemAdicional']);
            break;
        case 'editarCategoriaItem':
            editarCategoriaItem($_POST['idCategoriaItemAdicional']);
            break;
        case 'updateCategoriaItem':
            updateCategoriaItem($_POST['idCategoriaItemAdicional'], $_POST['stCategoriaItemAdicional']);
            break;
        case 'excluirCategoriaItem':
            excluirCategoriaItem($_POST['idCategoriaItemAdicional']);
            break;
    }
}


function getCategorias() {
    $qry = "SELECT idCategoria, stCategoria FROM prd_Categorias WHERE flAtivo = 1 ORDER BY stCategoria ASC";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $qryP = "SELECT COUNT(*) FROM prd_Produtos where idCategoria = '".$arr['idCategoria']."'";
        $resP = mssql_query($qryP);
        $arrP = mssql_fetch_array($resP)[0];
        $arr['nrProdutos'] = $arrP;
        $arr['stCategoria'] = utf8_encode($arr['stCategoria']);
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function cadastrarCategoria($categoria) {
    $categoria = sanitizeString2($categoria);

    $qry = "SELECT stCategoria FROM prd_Categorias WHERE stCategoria = '".$categoria."' AND flAtivo = '1'";

    if (mssql_fetch_assoc(mssql_query($qry))) {
        echo retornaJson(true, "Categoria ja Cadastrada");
    }
    else {
        if (isset($categoria)) {
            $query = 'SELECT MAX(idCategoria) from prd_categorias';
            $res = mssql_query($query);
            $idCategoria = (mssql_fetch_array($res)[0] + 1);

            $query = "INSERT INTO PRD_CATEGORIAS(idCategoria, stCategoria, flAtivo) VALUES(".$idCategoria.",'".$categoria."','1')";

            $res = mssql_query($query);
            if ($res) {
                echo retornaJson(true, 'Cadastrado com sucesso, recarregando a página.');
            }else{
                echo retornaJson(true, 'Erro ao cadastrar.');
            }
        }
    }
}

function editarCategoria($idCategoria, $stCategoria) {
    $stCategoria = sanitizeString2($stCategoria);

    $qry = "SELECT stCategoria FROM prd_Categorias WHERE stCategoria = '".$stCategoria."' AND flAtivo = '1'";

    if (mssql_fetch_assoc(mssql_query($qry))) {
        echo retornaJson(true, "Ja Existe uma Categoria com este Nome");
    }
    else {
        if (isset($idCategoria) && isset($stCategoria)) {
            $query = "UPDATE PRD_CATEGORIAS SET stCategoria = '".$stCategoria."' WHERE idCategoria = ".$idCategoria;
            $res = mssql_query($query);
            if ($res) {
                echo retornaJson(true, 'Categoria alterada com sucesso, recarregando a página.');
            }else{
                echo retornaJson(true, 'Erro ao atualizar.');
            }
        }
    }
}

function deleteCategoria($idCategoria) {
    $qry = "SELECT * FROM prd_SubCategorias WHERE idCategoria = ".$idCategoria."";
    $res = mssql_fetch_assoc(mssql_query($qry));

    if (!$res) {
        $qry = "DELETE FROM prd_Categorias WHERE idCategoria = ".$idCategoria."";
        $res = mssql_query($qry);

        echo retornaJson(true, 'Categoria deletada com sucesso.');
    }
    else {
        echo retornaJson(true, 'Erro. Esta Categoria possui Sub-Categorias.');
    }
}

function getSubCategorias($categoria) {
    $qry = "SELECT S.*, C.stCategoria FROM prd_SubCategorias S
	INNER JOIN prd_Categorias C ON S.idCategoria = C.idCategoria
	WHERE C.flAtivo = '1' AND C.idCategoria = ".$categoria." ORDER BY stCategoria, stSubCategoria ASC";
    $res = mssql_query($qry);

    $resR = mssql_fetch_array(mssql_query($qry));

    $arr['idCategoria'] = $categoria;
    $arr['stCategoria'] = $resR;
    $rows[] = $arr;

    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stCategoria'] = utf8_encode($arr['stCategoria']);
        $arr['stSubCategoria'] = utf8_encode($arr['stSubCategoria']);
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function cadastrarSubCategoria($subCategoria, $Categoria, $idSub) {
    $subCategoria = sanitizeString($subCategoria);
    $Categoria = intval($Categoria);

    if (strlen($idSub) > 0) {
        $qry = "UPDATE prd_SubCategorias SET stSubCategoria = '".$subCategoria."' WHERE idSubCategoria = ".$idSub." AND idCategoria = ".$Categoria."";
        $res = mssql_query($qry);

        if ($res) {
            echo retornaJson(true, 'Editado com sucesso, recarregando a página.');
        }
        else {
            echo retornaJson(true, 'Erro ao cadastrar.');
        }
    }
    else {
        $qry = "SELECT MAX(idSubCategoria) FROM prd_SubCategorias WHERE idCategoria = ".$Categoria."";
        $res = mssql_query($qry);

        if ($res) {
            $idSubCategoria = (mssql_fetch_array($res)[0] + 1);
        }
        else {
            $idSubCategoria = 1;
        }

        $qry = "SELECT stSubCategoria FROM prd_SubCategorias WHERE idCategoria = '".$Categoria."' AND stSubCategoria = '".$subCategoria."'";

        if (mssql_fetch_assoc(mssql_query($qry))) {
            echo retornaJson(true, "Ja Existe uma Categoria com este Nome");
        }
        else {
            $qry = "INSERT INTO prd_SubCategorias(idSubCategoria, idCategoria, stSubCategoria, dtAlteracao) VALUES(".$idSubCategoria.", ".$Categoria.", '".$subCategoria."', GETDATE())";
            $res = mssql_query($qry);
            if ($res) {
                echo retornaJson(true, 'Cadastrado com sucesso, recarregando a página.');
            }
            else {
                echo retornaJson(true, 'Erro ao cadastrar.');
            }
        }
    }
}

function editarSubCategoria($idCategoria, $idSubCategoria) {
    $qry = "SELECT idCategoria, idSubCategoria, stSubCategoria FROM prd_SubCategorias WHERE idCategoria = ".$idCategoria." AND idSubCategoria = ".$idSubCategoria."";
    $res = mssql_fetch_array(mssql_query($qry));

    $arr = $res;
    $rows[] = $arr;

    echo json_encode($rows);
}

function transferSub($idCategoria, $idSubCategoria, $idCategoriaOld, $idSubCategoriaOld) {
    $qry = "UPDATE prd_Produtos SET idCategoria = ".$idCategoria.", idSubCategoria = ".$idSubCategoria." WHERE idCategoria = ".$idCategoriaOld." AND idSubCategoria = ".$idSubCategoriaOld."";
    $res = mssql_query($qry);

    if ($res) {
        $query = "DELETE FROM prd_SubCategorias WHERE idSubCategoria = ".$idSubCategoriaOld." AND idCategoria = ".$idCategoriaOld."";
        $resD = mssql_query($query);

        if ($resD) {
            echo retornaJson(true, 'Sub-Categoria excluida com sucesso e Produtos Transferidos com sucesso, recarregando a página.');
        }
        else {
            echo retornaJson(true, 'Erro ao excluir Sub-Categoria.');
        }
    }
}

function getProdutosByCategoria($idCategoria) {
    $qry = "SELECT c.idCodigo, p.idProduto, p.stProduto, p.vrUnitario, p.vrCusto, p.vrMargemLucro FROM prd_Produtos p
	INNER JOIN prd_Codigos c ON p.idProduto = c.idProduto
	WHERE p.flAtivo = 1 AND p.idCategoria = ".$idCategoria." AND c.idCodigo <> '-100'";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $arr['stProduto'] = utf8_encode($arr['stProduto']);
        $arr['stProduto'] = utf8_encode($arr['stProduto']);
        $result[] = $arr;
    }
    echo json_encode($result);
}

function updatePrecos($itens) {
    $trans = true;
    for ($i=0; $i < count($itens) ; $i++) {
        $prd = $itens[$i];
        $qry = "UPDATE prd_Produtos SET vrCusto = ".$prd['custo'].", vrMargemLucro = ".$prd['margem'].", vrUnitario = ".$prd['venda']." WHERE idProduto = ".$prd['id'];
        $trans = mssql_query($qry);
    }

    if ($trans) {
        echo retornaJson(true, 'Sucesso!');
    } else {
        echo retornaJson(true, 'Erro!');
    }
}

function getCategoriasItens() {
    $qry = "SELECT idCategoriaItemAdicional, stCategoriaItemAdicional FROM prd_CategoriasItensAdicionais ORDER BY stCategoriaItemAdicional ASC";
    $res = mssql_query($qry);
    while ($arr = mssql_fetch_assoc($res)) {
        $rows[] = $arr;
    }
    echo json_encode($rows);
}

function cadastrarCategoriaItem($stCategoriaItemAdicional){
    $query = 'SELECT MAX(idCategoriaItemAdicional) from prd_CategoriasItensAdicionais';
    $res = mssql_query($query);
    $idCategoriaItemAdicional = (mssql_fetch_array($res)[0] + 1);

    $qry = "INSERT INTO prd_CategoriasItensAdicionais(idCategoriaItemAdicional, stCategoriaItemAdicional, dtAlteracao) VALUES(".$idCategoriaItemAdicional.", '".$stCategoriaItemAdicional."', GETDATE())";
    $res = mssql_query($qry);
    if ($res) {
        echo retornaJson(true, 'Cadastrado com sucesso, recarregando a página.');
    }
    else {
        echo retornaJson(true, 'Erro ao cadastrar.');
    }

}

function editarCategoriaItem($idCategoriaItemAdicional){

    $qry = "SELECT idCategoriaItemAdicional, stCategoriaItemAdicional FROM prd_CategoriasItensAdicionais WHERE idCategoriaItemAdicional = ".$idCategoriaItemAdicional."";
    $res = mssql_fetch_array(mssql_query($qry));

    echo json_encode($res);
}

function updateCategoriaItem($idCategoriaItemAdicional, $stCategoriaItemAdicional){

    $qry = "SELECT stCategoriaItemAdicional FROM prd_CategoriasItensAdicionais WHERE stCategoriaItemAdicional = '".$stCategoriaItemAdicional."'";

    if (mssql_fetch_assoc(mssql_query($qry))) {
        echo retornaJson(false, "Ja Existe uma Categoria Adicional com este Nome");
    }
    else {
        if (isset($idCategoriaItemAdicional) && isset($stCategoriaItemAdicional)) {
            $query = "UPDATE prd_CategoriasItensAdicionais SET stCategoriaItemAdicional = '".$stCategoriaItemAdicional."' WHERE idCategoriaItemAdicional = ".$idCategoriaItemAdicional;
            $res = mssql_query($query);
            if ($res) {
                echo retornaJson(true, 'Categoria Adicional alterada com sucesso, recarregando a página.');
            }else{
                echo retornaJson(false, 'Erro ao atualizar Categoria adicional.');
            }
        }
    }

}

function excluirCategoriaItem($idCategoriaItemAdicional){

    $erro = false;
    $qry = 'DELETE FROM prd_CategoriasItensAdicionais WHERE idCategoriaItemAdicional = '. $idCategoriaItemAdicional;
    mssql_query($qry) or $erro = true;
    if ($erro) {
        echo retornaJson(false, 'Erro ao excluir categoria Adicional.');
    }else{
        echo retornaJson(true, 'Categoria item Adicional excluido com sucesso.');
    }

}

?>