<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class MicroTerminal extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_Microterminais';
    protected $primaryKey = 'idMicroTerminal';
    protected $keyType = 'string';
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idMicroTerminal',
        'stMicroTerminal',
        'stTipo',
        'nrPorta',
        'nrTeclas',
        'flLeitor',
        'flOperador',
        'stBalanca',
        'flModoCheckOut',
        'idCaixa',
        'idOrigem',
        'idDestino',
        'stMarcaPrint',
        'flPrint',
        'stTipoPorta',
        'flPrintAll',
        'nrCOMDisplay',
        'stDisplay',
        'flAtivo',
        'dtAlteracao',
        'nrTabelaPreco'
    ];

    protected $appends = [
        'key'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flLeitor' => 'boolean',
        'flModoCheckOut' => 'boolean',
        'flPrint' => 'boolean',
        'flOperador' => 'boolean',
        'flPrintAll' => 'boolean',
    ];

    public function getKeyAttribute()
    {
        $key = Key::where('stComponente', $this->idMicroTerminal)->get('stChave')->first();
        if ($key){

            return $key['stChave'];
        }else{
            return null;
        }
    }

}
