<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SubCategoria extends Model implements Transformable
{
//    //    use HasCompositePrimaryKey;
    use TransformableTrait;

    protected $table = "prd_SubCategorias";
    protected $primaryKey = ['idSubCategoria', 'idCategoria'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idSubCategoria',
        'idCategoria',
        'stSubCategoria',
        'dtAlteracao',
    ];

    protected $appends = [
        'produtos_count'
    ];

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idSubCategoria', 'idSubCategoria');
    }

    public function getProdutosCountAttribute()
    {
        return $this->produtos()
            ->where('idCategoria', $this->idCategoria)
            ->where('idSubCategoria', $this->idSubCategoria)
            ->where('flAtivo',true)->count();
    }

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, "idCategoria");
    }
}
