<?php

namespace App\Http\Controllers;

use App\Entities\Financeiro\Credenciadora;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CredenciadorasController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request)
    {
        try {
            return response()->json(Credenciadora::all());

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
}
