<?php


namespace App\Http\Controllers\Delivery;


use App\Repositories\DlvOrderRepository;
use App\Services\Delivery\OrderService;

class PedidosController
{
    protected $repository;
    protected $service;

    public function __construct(DlvOrderRepository $repository, OrderService $service)
    {
        $this->repository = $repository;
        $this->service = $service;
    }

    public function index()
    {
        try {
            $response = $this->service->getPendingOrders();
            return response()->json($response);
        }catch (\Exception $e){
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function create()
    {
        return view('delivery.pedidos.create');
    }

    public function createStep1()
    {
        return view('delivery.pedidos.create');
    }
}
