<?php

namespace App\Http\Controllers;

use App\Entities\Nati\Ncm;
use App\Http\Controllers\Controller;


class NcmController extends Controller
{
    public function all()
    {
        return Ncm::get();
    }

    public function get($ncm)
    {
        return json_encode(Ncm::where('ncm', '=', $ncm)->first());
    }

    public function find($text)
    {
        if (strlen($text) > 0) {
            $text = '%' . $text . '%';
            $ncm = Ncm::where('ncm', 'like', $text)->orWhere('description', 'like', $text)->take(5)->get();

            if (count($ncm)) {
                return json_encode($ncm);

            } else {
                return null;
            }

        }
    }

    public function findOldVersion($text)
    {
        if (strlen($text) > 0) {
            $text = '%' . $text . '%';
            $ncm = Ncm::where('ncm', 'like', $text)->orWhere('description', 'like', $text)->take(5)->get();

            if (count($ncm)) {
                return json_encode($ncm);

            } else {
                $ncm['ncm'] = $text;
                $ncm['description'] = 'NCM MANUAL';
                return json_encode($ncm);
            }

        }
    }
}
