<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\SatEquipamentosService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\Nati\SatEquipamentoCreateRequest;
use App\Http\Requests\Nati\SatEquipamentoUpdateRequest;


class SatEquipamentosController extends Controller
{

  protected $service;

    public function __construct(SatEquipamentosService $service)
    {
        $this->service = $service;
    }


    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        try
        {
            $eqpSat = $this->service->all();

            return response()->json($eqpSat);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  SatEquipamentoCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(SatEquipamentoCreateRequest $request)
    {
        try {
            $eqpSat = $this->service->create($request->all());

            $response = [
                'message' => 'Sat Equipamento created.',
                'data'    => $eqpSat->toArray(),
            ];
            return response()->json($response, 201);

        }catch (ModelNotFoundException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
        catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try
        {
            $eqpSat = $this->service->getById($id);

            return response()->json($eqpSat);
        }
        catch(\Exception $exception)
        {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  SatEquipamentoUpdateRequest $request
     * @param  string            $id
     *
     * @return Response
     */
    public function update(SatEquipamentoUpdateRequest $request, $id)
    {
        try {
            $eqpSat = $this->service->update($request->all(), $id);
            return response()->json([
                'message' => 'Sat Equipamento Update',
                'data' => $eqpSat
            ],201);


        }catch (ModelNotFoundException $e)
        {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);

        } catch (ValidatorException $e) {

            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $eqpSat = $this->service->delete($id);

            $response = [
                'message' => 'Sat Equipamento deleted.',
                'data'    => $eqpSat,
            ];
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
