<?php

namespace App\Repositories;

use App\Entities\Financeiro\Bandeira;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\BandeiraRepository;
use App\Validators\BandeiraValidator;

/**
 * Class BandeiraRepositoryEloquent
 * @package namespace App\Repositories;
 */
class BandeiraRepositoryEloquent extends BaseRepository implements BandeiraRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Bandeira::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return BandeiraValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
