<?php

namespace App\Repositories;

use App\Entities\Entregador;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\EntregadorRepository;
use App\Entities\SalesView;
use App\Validators\EntregadorValidator;

/**
 * Class EntregadorRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class EntregadorRepositoryEloquent extends BaseRepository implements EntregadorRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Entregador::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {
        return EntregadorValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }

}
