<?php


namespace App\Services;


use App\Entities\Comanda;
use App\Jobs\ProcessComanda;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Http;

class DesenfilaService
{
    protected $comandaService;

    public function __construct(ComandaService $service)
    {
        $this->comandaService = $service;
    }

    public function sendComanda()
    {
        $comandas = $this->comandaService->getComandas();

        foreach ($comandas as $comanda) {
            $this->httpPost($comanda);
        }
    }

    public function getPaid()
    {
        $c = Comanda::all();
        $res = $this->httpGet();
        if($res){
//            $batch  = Bus::batch([])->dispatch();
            foreach ($res['items'] as $comanda) {
                $c = Comanda::with('itens')->find($comanda['pos']);

                $c['pagamentos'] = $comanda['payment'];
                $c['dest'] = $comanda['dest'];

                dispatch(new ProcessComanda($c));
                $c->delete();
//                $batch->add(new ProcessComanda($c));
            }
//            return $batch;
        }
    }

    private function httpGet()
    {
        $url = env('DESENFILA_API') . '/orders/get-orders-ready-for-automation';

        try {
            $response = Http::get($url);

            $data = $response->getBody();
            $data = json_decode($data, true);
            return $data;

        } catch (\Exception $e) {
            return null;
        }
    }

    private function httpPost(Comanda $comanda)
    {
        $url = env('DESENFILA_API') . '/orders';

        $com = [
            "refId" => $comanda->uuid,
            "pos" => $comanda->idComanda,
            "discount" => 0,
            "addition" => 0,
            "invite" => 0,
            "consumation" => 0,
            "diffConsumation" => 0,
            "items" => [],
            "netAmount" => $comanda->vrTotal,
            "amount" => $comanda->vrTotal
        ];

        foreach ($comanda->itens as $iten) {
            $iten = [
                "id" => $iten->nrItem,
                "code" => $iten->codigo,
                "name" => $iten->descricao,
                "quantity" => $iten->nrQuantidade,
                "unitPrice" => $iten->vrUnitario,
                "netAmount" => $iten->vrTotal,
                "addition" => 0,
                "discount" => 0
            ];
            array_push($com['items'], $iten);
        }

        try {
            $response = Http::post($url, $com);
        } catch (\Exception $e) {
            return $e;
        }

        $data = $response->getBody();
        $data = json_decode($data, true);
    }
}
